/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync.optimize;

import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.sync.DirectorySynchronizer;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.optimize.DirectoryActionOptimizer;
import com.openexchange.drive.sync.optimize.DirectoryOrderOptimizer;
import com.openexchange.drive.sync.optimize.DirectoryRemoveOptimizer;
import com.openexchange.drive.sync.optimize.DirectoryRenameOptimizer;
import com.openexchange.drive.sync.optimize.EmptyDirectoryOptimizer;
import com.openexchange.exception.OXException;

public class OptimizingDirectorySynchronizer
extends DirectorySynchronizer {
    public OptimizingDirectorySynchronizer(SyncSession session, VersionMapper<DirectoryVersion> mapper) throws OXException {
        super(session, mapper);
    }

    @Override
    public IntermediateSyncResult<DirectoryVersion> sync() throws OXException {
        IntermediateSyncResult<DirectoryVersion> result = super.sync();
        if (!result.isEmpty()) {
            DirectoryActionOptimizer[] optimizers;
            int lastResults = 0;
            if (this.session.isTraceEnabled()) {
                lastResults = result.hashCode();
                this.session.trace("Sync results before optimizations:\n" + result.toString());
            }
            for (DirectoryActionOptimizer optimizer : optimizers = new DirectoryActionOptimizer[]{new DirectoryRemoveOptimizer(this.mapper), new DirectoryRenameOptimizer(this.mapper), new EmptyDirectoryOptimizer(this.mapper), new DirectoryOrderOptimizer(this.mapper)}) {
                int currentResults;
                result = optimizer.optimize(this.session, result);
                if (!this.session.isTraceEnabled() || (currentResults = result.hashCode()) == lastResults) continue;
                lastResults = currentResults;
                this.session.trace("Sync results after optimizations of " + optimizer.getClass().getSimpleName() + ":\n" + result.toString());
            }
        }
        return result;
    }
}

