/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync.optimize;

import com.openexchange.drive.Action;
import com.openexchange.drive.DriveConstants;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.actions.AcknowledgeFileAction;
import com.openexchange.drive.actions.DownloadFileAction;
import com.openexchange.drive.checksum.FileChecksum;
import com.openexchange.drive.comparison.ServerFileVersion;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.storage.StorageOperation;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.optimize.FileActionOptimizer;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.search.FileMd5SumTerm;
import com.openexchange.file.storage.search.OrTerm;
import com.openexchange.file.storage.search.SearchTerm;
import com.openexchange.java.Strings;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileCopyOptimizer
extends FileActionOptimizer {
    public FileCopyOptimizer(VersionMapper<FileVersion> mapper) {
        super(mapper);
    }

    @Override
    public IntermediateSyncResult<FileVersion> optimize(SyncSession session, IntermediateSyncResult<FileVersion> result) {
        Map<String, ServerFileVersion> knownFileVersions;
        ArrayList optimizedActionsForClient = new ArrayList(result.getActionsForClient());
        ArrayList optimizedActionsForServer = new ArrayList(result.getActionsForServer());
        ArrayList<AbstractAction<FileVersion>> uploadActions = new ArrayList<AbstractAction<FileVersion>>();
        HashSet<String> checksums = new HashSet<String>();
        for (AbstractAction<FileVersion> clientAction : result.getActionsForClient()) {
            if (Action.UPLOAD != clientAction.getAction()) continue;
            checksums.add(clientAction.getNewVersion().getChecksum());
            uploadActions.add(clientAction);
        }
        if (0 < uploadActions.size() && 0 < (knownFileVersions = this.findByChecksum(session, checksums)).size()) {
            for (AbstractAction abstractAction : uploadActions) {
                ServerFileVersion knownFileVersion = knownFileVersions.get(((FileVersion)abstractAction.getNewVersion()).getChecksum());
                if (null == knownFileVersion) continue;
                String path = (String)abstractAction.getParameters().get("path");
                optimizedActionsForClient.remove(abstractAction);
                DownloadFileAction serverDownload = new DownloadFileAction(session, (FileVersion)abstractAction.getVersion(), (FileVersion)abstractAction.getNewVersion(), null, path, null);
                serverDownload.getParameters().put("sourceVersion", knownFileVersion);
                AcknowledgeFileAction clientAcknowledge = new AcknowledgeFileAction(session, (FileVersion)abstractAction.getVersion(), (FileVersion)abstractAction.getNewVersion(), null, path, null);
                clientAcknowledge.setDependingAction(serverDownload);
                optimizedActionsForServer.add(serverDownload);
                optimizedActionsForClient.add(clientAcknowledge);
            }
        }
        return new IntermediateSyncResult<FileVersion>(optimizedActionsForServer, optimizedActionsForClient);
    }

    private static ServerFileVersion findByChecksum(String checksum, Collection<? extends FileVersion> versions) {
        if (null != versions && 0 < versions.size()) {
            for (FileVersion fileVersion : versions) {
                if (!ServerFileVersion.class.isInstance(fileVersion) || !checksum.equals(fileVersion.getChecksum())) continue;
                return (ServerFileVersion)fileVersion;
            }
        }
        return null;
    }

    private Map<String, ServerFileVersion> findByChecksum(SyncSession session, Set<String> checksums) {
        if (null == checksums || 0 == checksums.size()) {
            return Collections.emptyMap();
        }
        HashMap<String, ServerFileVersion> matchingFileVersions = new HashMap<String, ServerFileVersion>();
        ArrayList<String> checksumsToQuery = new ArrayList<String>(checksums.size());
        Collection serverVersions = this.mapper.getServerVersions();
        for (String checksum : checksums) {
            ServerFileVersion fileVersion = FileCopyOptimizer.findByChecksum(checksum, serverVersions);
            if (null == fileVersion) {
                checksumsToQuery.add(checksum);
                continue;
            }
            matchingFileVersions.put(checksum, fileVersion);
        }
        if (0 < checksumsToQuery.size()) {
            try {
                matchingFileVersions.putAll(FileCopyOptimizer.getMatchingFileVersions(session, checksumsToQuery));
            }
            catch (OXException e) {
                LOG.warn("unexpected error during file lookup by checksum", (Throwable)e);
            }
            checksumsToQuery.removeAll(matchingFileVersions.keySet());
            if (0 < checksumsToQuery.size()) {
                try {
                    matchingFileVersions.putAll(FileCopyOptimizer.searchMatchingFileVersions(session, checksumsToQuery));
                }
                catch (OXException e) {
                    LOG.warn("unexpected error during file lookup by checksum", (Throwable)e);
                }
                checksumsToQuery.removeAll(matchingFileVersions.keySet());
                if (0 < checksumsToQuery.size()) {
                    try {
                        if (session.getStorage().hasTrashFolder() && null != session.getStorage().getTrashFolder()) {
                            String trashFolderID = session.getStorage().getTrashFolder().getId();
                            matchingFileVersions.putAll(FileCopyOptimizer.searchMatchingFileVersions(session, Collections.singletonList(trashFolderID), checksumsToQuery));
                        }
                    }
                    catch (OXException e) {
                        LOG.warn("unexpected error during file lookup by checksum", (Throwable)e);
                    }
                }
            }
        }
        return matchingFileVersions;
    }

    private static Map<String, ServerFileVersion> searchMatchingFileVersions(SyncSession session, List<String> checksums) throws OXException {
        return FileCopyOptimizer.searchMatchingFileVersions(session, null, checksums);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ServerFileVersion> searchMatchingFileVersions(final SyncSession session, final List<String> folderIDs, final List<String> checksums) throws OXException {
        HashMap<String, ServerFileVersion> matchingFileVersions = new HashMap<String, ServerFileVersion>();
        if (0 < checksums.size() && session.getStorage().supports(FileStorageCapability.SEARCH_BY_TERM)) {
            ArrayList<FileChecksum> checksumsToInsert = new ArrayList<FileChecksum>();
            SearchIterator<File> searchIterator = null;
            try {
                searchIterator = session.getStorage().wrapInTransaction(new StorageOperation<SearchIterator<File>>(){

                    @Override
                    public SearchIterator<File> call() throws OXException {
                        return session.getStorage().getFileAccess().search(folderIDs, FileCopyOptimizer.getSearchTermForChecksums(checksums), DriveConstants.FILE_FIELDS, null, FileStorageFileAccess.SortDirection.DEFAULT, -11, -11);
                    }
                });
                while (searchIterator.hasNext()) {
                    File file = (File)searchIterator.next();
                    String md5 = file.getFileMD5Sum();
                    if (Strings.isEmpty((String)md5)) continue;
                    FileChecksum fileChecksum = new FileChecksum(DriveUtils.getFileID(file), file.getVersion(), file.getSequenceNumber(), md5);
                    checksumsToInsert.add(fileChecksum);
                    matchingFileVersions.put(fileChecksum.getChecksum(), new ServerFileVersion(file, fileChecksum));
                }
            }
            finally {
                SearchIterators.close(searchIterator);
            }
            if (0 < checksumsToInsert.size()) {
                session.getChecksumStore().insertFileChecksums(checksumsToInsert);
            }
        }
        return matchingFileVersions;
    }

    private static SearchTerm<?> getSearchTermForChecksums(List<String> checksumsToQuery) {
        if (null == checksumsToQuery || 0 == checksumsToQuery.size()) {
            return null;
        }
        if (1 == checksumsToQuery.size()) {
            return new FileMd5SumTerm(checksumsToQuery.get(0));
        }
        ArrayList<FileMd5SumTerm> md5Terms = new ArrayList<FileMd5SumTerm>(checksumsToQuery.size());
        for (String checksum : checksumsToQuery) {
            md5Terms.add(new FileMd5SumTerm(checksum));
        }
        return new OrTerm(md5Terms);
    }

    private static boolean indicatesInvalidation(OXException e) {
        return !Category.CATEGORY_PERMISSION_DENIED.equals(e.getCategory());
    }

    private static Map<String, ServerFileVersion> getMatchingFileVersions(SyncSession session, List<String> checksums) throws OXException {
        HashMap<String, ServerFileVersion> matchingFileVersions = new HashMap<String, ServerFileVersion>();
        ArrayList<FileChecksum> checksumsToInvalidate = new ArrayList<FileChecksum>();
        Map<String, List<FileChecksum>> storedFileChecksums = session.getChecksumStore().getMatchingFileChecksums(checksums);
        HashMap<FolderID, Integer> folderPermissions = new HashMap<FolderID, Integer>();
        block4: for (List<FileChecksum> storedChecksums : storedFileChecksums.values()) {
            File matchingFile = null;
            for (FileChecksum storedChecksum : storedChecksums) {
                block13: {
                    FileID fileID = storedChecksum.getFileID();
                    FolderID folderID = new FolderID(fileID.getService(), fileID.getAccountId(), fileID.getFolderId());
                    Integer readPermissions = null;
                    if (!folderPermissions.containsKey(folderID)) {
                        block12: {
                            FileStorageFolder folder = null;
                            try {
                                folder = session.getStorage().getFolderAccess().getFolder(folderID.toUniqueID());
                                if (null != folder) {
                                    readPermissions = folder.getOwnPermission().getReadPermission();
                                }
                            }
                            catch (OXException e) {
                                LOG.debug("Error accessing folder referenced by checksum store: {}", (Object)e.getMessage());
                                if (FileCopyOptimizer.indicatesInvalidation(e)) break block12;
                                readPermissions = 0;
                            }
                        }
                        folderPermissions.put(folderID, readPermissions);
                    } else {
                        readPermissions = (Integer)folderPermissions.get(folderID);
                    }
                    if (null == readPermissions) {
                        checksumsToInvalidate.add(storedChecksum);
                        continue;
                    }
                    if (0 == readPermissions) continue;
                    try {
                        matchingFile = session.getStorage().getFile(storedChecksum.getFileID().toUniqueID(), storedChecksum.getVersion());
                    }
                    catch (OXException e) {
                        LOG.debug("Error accessing file referenced by checksum store: {}", (Object)e.getMessage());
                        if (!FileCopyOptimizer.indicatesInvalidation(e)) break block13;
                        checksumsToInvalidate.add(storedChecksum);
                    }
                }
                if (null == matchingFile) continue;
                if (FileCopyOptimizer.matches(storedChecksum, matchingFile)) {
                    matchingFileVersions.put(storedChecksum.getChecksum(), new ServerFileVersion(matchingFile, storedChecksum));
                    continue block4;
                }
                checksumsToInvalidate.add(storedChecksum);
            }
        }
        if (0 < checksumsToInvalidate.size()) {
            session.getChecksumStore().removeFileChecksums(checksumsToInvalidate);
        }
        return matchingFileVersions;
    }

    private static boolean matches(FileChecksum checksum, File file) {
        if (null == checksum) {
            return null == file;
        }
        if (null != file) {
            return checksum.getSequenceNumber() == file.getSequenceNumber() && (null == checksum.getVersion() ? null == file.getVersion() : checksum.getVersion().equals(file.getVersion()));
        }
        return false;
    }
}

