/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync.optimize;

import com.openexchange.drive.Action;
import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.actions.AcknowledgeDirectoryAction;
import com.openexchange.drive.actions.EditDirectoryAction;
import com.openexchange.drive.actions.SyncDirectoryAction;
import com.openexchange.drive.comparison.Change;
import com.openexchange.drive.comparison.ThreeWayComparison;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.optimize.DirectoryActionOptimizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DirectoryRenameOptimizer
extends DirectoryActionOptimizer {
    public DirectoryRenameOptimizer(VersionMapper<DirectoryVersion> mapper) {
        super(mapper);
    }

    @Override
    public IntermediateSyncResult<DirectoryVersion> optimize(SyncSession session, IntermediateSyncResult<DirectoryVersion> result) {
        boolean hasChanged;
        IntermediateSyncResult<DirectoryVersion> unoptimizedResult = result;
        IntermediateSyncResult<DirectoryVersion> optimizedResult = null;
        int optimizationCount = 0;
        do {
            hasChanged = false == (optimizedResult = this.optimizeServerRenames(this.optimizeClientRenames(unoptimizedResult))).equals(unoptimizedResult);
            unoptimizedResult = optimizedResult;
        } while (hasChanged && ++optimizationCount < 100);
        if (0 < optimizationCount) {
            List actionsForClient = optimizedResult.getActionsForClient();
            actionsForClient.removeAll(DirectoryRenameOptimizer.getRedundantRenames(DirectoryRenameOptimizer.filterByAction(actionsForClient, Action.EDIT)));
            List actionsForServer = optimizedResult.getActionsForServer();
            actionsForServer.removeAll(DirectoryRenameOptimizer.getRedundantRenames(DirectoryRenameOptimizer.filterByAction(actionsForServer, Action.EDIT)));
            optimizedResult = new IntermediateSyncResult(actionsForServer, actionsForClient);
        }
        return optimizedResult;
    }

    private IntermediateSyncResult<DirectoryVersion> optimizeClientRenames(IntermediateSyncResult<DirectoryVersion> result) {
        ArrayList<AbstractAction<DirectoryVersion>> optimizedActionsForClient = new ArrayList<AbstractAction<DirectoryVersion>>(result.getActionsForClient());
        ArrayList<AbstractAction<DirectoryVersion>> optimizedActionsForServer = new ArrayList<AbstractAction<DirectoryVersion>>(result.getActionsForServer());
        for (AbstractAction<DirectoryVersion> serverAction : result.getActionsForServer()) {
            if (!Action.REMOVE.equals((Object)serverAction.getAction()) || !serverAction.wasCausedBy(Change.DELETED, Change.NONE)) continue;
            for (AbstractAction<DirectoryVersion> clientAction : result.getActionsForClient()) {
                if (!Action.ACKNOWLEDGE.equals((Object)clientAction.getAction()) || null != clientAction.getNewVersion() || !clientAction.wasCausedBy(Change.DELETED, Change.NONE) || !DirectoryRenameOptimizer.matchesByPathAndChecksum(clientAction.getVersion(), serverAction.getVersion())) continue;
                AbstractAction<DirectoryVersion> clientSync = DirectoryRenameOptimizer.findBestMatchingAction(optimizedActionsForClient, Action.SYNC, clientAction.getVersion(), Change.NEW, Change.NONE);
                AbstractAction<DirectoryVersion> serverSync = DirectoryRenameOptimizer.findBestMatchingAction(optimizedActionsForServer, Action.SYNC, clientAction.getVersion(), Change.NEW, Change.NONE);
                if (null == clientSync || null == serverSync) continue;
                optimizedActionsForServer.remove(serverSync);
                optimizedActionsForServer.remove(serverAction);
                optimizedActionsForServer.add(new EditDirectoryAction(serverAction.getVersion(), clientSync.getVersion(), null));
                optimizedActionsForClient.remove(clientAction);
                ThreeWayComparison<DirectoryVersion> comparison = new ThreeWayComparison<DirectoryVersion>();
                comparison.setOriginalVersion(clientAction.getVersion());
                optimizedActionsForClient.add(new AcknowledgeDirectoryAction(clientAction.getVersion(), null, comparison));
                optimizedActionsForClient.remove(clientSync);
                comparison = new ThreeWayComparison();
                comparison.setClientVersion(clientSync.getVersion());
                comparison.setServerVersion(clientSync.getVersion());
                optimizedActionsForClient.add(new SyncDirectoryAction(clientSync.getVersion(), comparison));
                DirectoryRenameOptimizer.restoreNestedRemoves(serverAction, optimizedActionsForServer);
            }
        }
        return new IntermediateSyncResult<DirectoryVersion>(optimizedActionsForServer, optimizedActionsForClient);
    }

    private IntermediateSyncResult<DirectoryVersion> optimizeServerRenames(IntermediateSyncResult<DirectoryVersion> result) {
        ArrayList<AbstractAction<DirectoryVersion>> optimizedActionsForClient = new ArrayList<AbstractAction<DirectoryVersion>>(result.getActionsForClient());
        ArrayList optimizedActionsForServer = new ArrayList(result.getActionsForServer());
        for (AbstractAction<DirectoryVersion> clientAction : result.getActionsForClient()) {
            AbstractAction<DirectoryVersion> clientSync;
            if (Action.REMOVE != clientAction.getAction() || !clientAction.wasCausedBy(Change.NONE, Change.DELETED) || null == (clientSync = DirectoryRenameOptimizer.findBestMatchingAction(optimizedActionsForClient, Action.SYNC, clientAction.getVersion(), Change.NONE, Change.NEW))) continue;
            optimizedActionsForClient.remove(clientAction);
            optimizedActionsForClient.remove(clientSync);
            EditDirectoryAction renameDirectoryAction = new EditDirectoryAction(clientAction.getVersion(), clientSync.getVersion(), null);
            optimizedActionsForClient.add(renameDirectoryAction);
            DirectoryRenameOptimizer.restoreNestedRemoves(clientAction, optimizedActionsForClient);
        }
        return new IntermediateSyncResult<DirectoryVersion>(optimizedActionsForServer, optimizedActionsForClient);
    }

    private static int restoreNestedRemoves(AbstractAction<DirectoryVersion> parentAction, List<AbstractAction<DirectoryVersion>> originalActions) {
        List nestedRemoves;
        int restored = 0;
        if (parentAction.getParameters().containsKey("nestedRemoves") && null != (nestedRemoves = (List)parentAction.getParameters().get("nestedRemoves")) && 0 < nestedRemoves.size()) {
            for (AbstractAction nestedRemove : nestedRemoves) {
                if (originalActions.contains(nestedRemove)) continue;
                if (originalActions.add(nestedRemove)) {
                    ++restored;
                }
                restored += DirectoryRenameOptimizer.restoreNestedRemoves(nestedRemove, originalActions);
            }
        }
        return restored;
    }

    private static AbstractAction<DirectoryVersion> findBestMatchingAction(List<AbstractAction<DirectoryVersion>> driveActions, Action action, DirectoryVersion version, Change clientChange, Change serverChange) {
        AbstractAction<DirectoryVersion> renameAction = null;
        int similarityScore = 0;
        for (AbstractAction<DirectoryVersion> driveAction : driveActions) {
            if (!action.equals((Object)driveAction.getAction()) || !DirectoryRenameOptimizer.matchesByChecksum(version, driveAction.getVersion()) || !driveAction.wasCausedBy(clientChange, serverChange)) continue;
            int similarity = DirectoryRenameOptimizer.calculateSimilarity(version.getPath(), driveAction.getVersion().getPath());
            if (null != renameAction && similarity <= similarityScore) continue;
            similarityScore = similarity;
            renameAction = driveAction;
        }
        return renameAction;
    }

    private static int calculateSimilarity(String path1, String path2) {
        int i;
        if (null == path1) {
            return null == path2 ? Integer.MAX_VALUE : 0;
        }
        if (null == path2) {
            return null == path1 ? Integer.MAX_VALUE : 0;
        }
        if (path1.equals(path2)) {
            return Integer.MAX_VALUE;
        }
        String[] splitted1 = path1.split("/");
        String[] splitted2 = path2.split("/");
        int score = 0;
        int minLength = Math.min(splitted1.length, splitted2.length);
        for (i = 0; i < minLength; ++i) {
            if (!splitted1[i].equals(splitted2[i])) continue;
            ++score;
        }
        for (i = 1; i <= minLength; ++i) {
            if (!splitted1[splitted1.length - i].equals(splitted2[splitted2.length - i])) continue;
            ++score;
        }
        return score;
    }

    private static List<AbstractAction<DirectoryVersion>> getRedundantRenames(List<AbstractAction<DirectoryVersion>> renameActions) {
        Collections.sort(renameActions, new Comparator<AbstractAction<DirectoryVersion>>(){

            @Override
            public int compare(AbstractAction<DirectoryVersion> o1, AbstractAction<DirectoryVersion> o2) {
                if (null != o1 && null != o2 && Action.EDIT.equals((Object)o1.getAction()) && Action.EDIT.equals((Object)o2.getAction()) && null != o1.getNewVersion() && null != o2.getNewVersion()) {
                    return o1.getNewVersion().getPath().compareTo(o2.getNewVersion().getPath());
                }
                return 0;
            }
        });
        ArrayList<AbstractAction<DirectoryVersion>> effectiveRenames = new ArrayList<AbstractAction<DirectoryVersion>>();
        for (AbstractAction<DirectoryVersion> renameAction : renameActions) {
            String oldPath = renameAction.getVersion().getPath();
            String newPath = renameAction.getNewVersion().getPath();
            boolean redundant = false;
            for (AbstractAction abstractAction : effectiveRenames) {
                String renamedOldPath = ((DirectoryVersion)abstractAction.getVersion()).getPath();
                String renamedNewPath = ((DirectoryVersion)abstractAction.getNewVersion()).getPath();
                if (!oldPath.startsWith(renamedOldPath + '/') || !newPath.startsWith(renamedNewPath + '/')) continue;
                String effectiveOldPath = oldPath.substring(renamedOldPath.length());
                String effectiveNewPath = newPath.substring(renamedNewPath.length());
                if (!effectiveNewPath.equals(effectiveOldPath)) continue;
                redundant = true;
            }
            if (redundant) continue;
            effectiveRenames.add(renameAction);
        }
        ArrayList<AbstractAction<DirectoryVersion>> redundantRenames = new ArrayList<AbstractAction<DirectoryVersion>>(renameActions);
        redundantRenames.removeAll(effectiveRenames);
        return redundantRenames;
    }
}

