/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync.optimize;

import com.openexchange.drive.Action;
import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.comparison.Change;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.optimize.DirectoryActionOptimizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DirectoryRemoveOptimizer
extends DirectoryActionOptimizer {
    public DirectoryRemoveOptimizer(VersionMapper<DirectoryVersion> mapper) {
        super(mapper);
    }

    @Override
    public IntermediateSyncResult<DirectoryVersion> optimize(SyncSession session, IntermediateSyncResult<DirectoryVersion> result) {
        List clientActions = result.getActionsForClient();
        clientActions.removeAll(DirectoryRemoveOptimizer.getRedundantRemoves(clientActions));
        List serverActions = result.getActionsForServer();
        serverActions.removeAll(DirectoryRemoveOptimizer.getRedundantRemoves(serverActions));
        return new IntermediateSyncResult<DirectoryVersion>(serverActions, clientActions);
    }

    private static List<AbstractAction<DirectoryVersion>> getRedundantRemoves(List<AbstractAction<DirectoryVersion>> driveActions) {
        List<AbstractAction<DirectoryVersion>> removeActions = DirectoryRemoveOptimizer.getNonConflictingRemoves(driveActions);
        Collections.sort(removeActions);
        Collections.reverse(removeActions);
        ArrayList<AbstractAction<DirectoryVersion>> redundantRemoves = new ArrayList<AbstractAction<DirectoryVersion>>();
        for (int i = 0; i < removeActions.size(); ++i) {
            String prefix = removeActions.get(i).getVersion().getPath() + '/';
            for (int j = i + 1; j < removeActions.size(); ++j) {
                List<AbstractAction<DirectoryVersion>> nestedRemoves;
                if (!removeActions.get(j).getVersion().getPath().startsWith(prefix)) continue;
                redundantRemoves.add(removeActions.get(j));
                Map<String, Object> parameters = removeActions.get(i).getParameters();
                if (parameters.containsKey("nestedRemoves")) {
                    nestedRemoves = (List)removeActions.get(i).getParameters().get("nestedRemoves");
                } else {
                    nestedRemoves = new ArrayList();
                    parameters.put("nestedRemoves", nestedRemoves);
                }
                nestedRemoves.add(removeActions.get(j));
            }
        }
        return redundantRemoves;
    }

    private static List<AbstractAction<DirectoryVersion>> getNonConflictingRemoves(List<AbstractAction<DirectoryVersion>> driveActions) {
        ArrayList<AbstractAction<DirectoryVersion>> removeActions = new ArrayList<AbstractAction<DirectoryVersion>>();
        for (AbstractAction<DirectoryVersion> driveAction : driveActions) {
            if (!Action.REMOVE.equals((Object)driveAction.getAction()) || !driveAction.wasCausedBy(Change.DELETED, Change.NONE) && !driveAction.wasCausedBy(Change.NONE, Change.DELETED) && !driveAction.wasCausedBy(Change.DELETED, Change.DELETED)) continue;
            removeActions.add(driveAction);
        }
        return removeActions;
    }
}

