/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync.optimize;

import com.openexchange.drive.Action;
import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.sync.optimize.ActionOptimizer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionOptimizer<T extends DriveVersion>
implements ActionOptimizer<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractActionOptimizer.class);
    protected final VersionMapper<T> mapper;

    public AbstractActionOptimizer(VersionMapper<T> mapper) {
        this.mapper = mapper;
    }

    protected static <T extends DriveVersion> boolean matchesByChecksum(T v1, T v2) {
        if (null == v1) {
            return null == v2;
        }
        if (null == v2) {
            return null == v1;
        }
        return null == v1.getChecksum() ? null == v2.getChecksum() : v1.getChecksum().equals(v2.getChecksum());
    }

    protected static <T extends DriveVersion> List<AbstractAction<T>> filterByAction(List<AbstractAction<T>> driveActions, Action action) {
        ArrayList<AbstractAction<T>> filteredActions = new ArrayList<AbstractAction<T>>();
        for (AbstractAction<T> driveAction : driveActions) {
            if (null == driveAction || !action.equals((Object)driveAction.getAction())) continue;
            filteredActions.add(driveAction);
        }
        return filteredActions;
    }
}

