/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync;

import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.comparison.Change;
import com.openexchange.drive.comparison.ThreeWayComparison;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.exception.OXException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Synchronizer<T extends DriveVersion> {
    protected static final Logger LOG = LoggerFactory.getLogger(Synchronizer.class);
    protected final SyncSession session;
    protected final VersionMapper<T> mapper;

    public Synchronizer(SyncSession session, VersionMapper<T> mapper) throws OXException {
        this.session = session;
        this.mapper = mapper;
    }

    public IntermediateSyncResult<T> sync() throws OXException {
        IntermediateSyncResult result = new IntermediateSyncResult();
        int maxActions = this.getMaxActions();
        int nonTrivialActionCount = 0;
        for (Map.Entry<String, ThreeWayComparison<T>> entry : this.mapper) {
            if ((nonTrivialActionCount += this.process(result, entry.getValue())) <= maxActions) continue;
            this.session.trace("Interrupting processing since the maximum number of non-trivial actions (" + maxActions + ") is exceeded.");
            break;
        }
        return result;
    }

    private int process(IntermediateSyncResult<T> result, ThreeWayComparison<T> comparison) throws OXException {
        Change clientChange = comparison.getClientChange();
        Change serverChange = comparison.getServerChange();
        if (Change.NONE == clientChange && Change.NONE == serverChange) {
            return 0;
        }
        if (Change.NONE == clientChange && Change.NONE != serverChange) {
            return this.processServerChange(result, comparison);
        }
        if (Change.NONE != clientChange && Change.NONE == serverChange) {
            return this.processClientChange(result, comparison);
        }
        return this.processConflictingChange(result, comparison);
    }

    protected abstract int processServerChange(IntermediateSyncResult<T> var1, ThreeWayComparison<T> var2) throws OXException;

    protected abstract int processClientChange(IntermediateSyncResult<T> var1, ThreeWayComparison<T> var2) throws OXException;

    protected abstract int processConflictingChange(IntermediateSyncResult<T> var1, ThreeWayComparison<T> var2) throws OXException;

    protected abstract int getMaxActions();
}

