/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync;

import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.actions.AbstractAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IntermediateSyncResult<T extends DriveVersion> {
    private final List<AbstractAction<T>> actionsForServer;
    private final List<AbstractAction<T>> actionsForClient;

    public IntermediateSyncResult(List<AbstractAction<T>> actionsForServer, List<AbstractAction<T>> actionsForClient) {
        this.actionsForClient = actionsForClient;
        this.actionsForServer = actionsForServer;
    }

    public IntermediateSyncResult() {
        this(new ArrayList<AbstractAction<T>>(), new ArrayList<AbstractAction<T>>());
    }

    public void addActionForClient(AbstractAction<T> action) {
        this.actionsForClient.add(action);
    }

    public void addActionsForClient(Collection<? extends AbstractAction<T>> actions) {
        this.actionsForClient.addAll(actions);
    }

    public void addActionForServer(AbstractAction<T> action) {
        this.actionsForServer.add(action);
    }

    public boolean isEmpty() {
        return !(null != this.actionsForServer && 0 != this.actionsForServer.size() || null != this.actionsForClient && 0 != this.actionsForClient.size());
    }

    public List<AbstractAction<T>> getActionsForServer() {
        return this.actionsForServer;
    }

    public List<AbstractAction<T>> getActionsForClient() {
        return this.actionsForClient;
    }

    public int length() {
        return (null == this.actionsForServer ? 0 : this.actionsForServer.size()) + (null == this.actionsForClient ? 0 : this.actionsForClient.size());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != this.actionsForServer) {
            stringBuilder.append("Actions for server:\n");
            for (AbstractAction<T> action : this.actionsForServer) {
                stringBuilder.append("  ").append(action).append('\n');
                if (100000 >= stringBuilder.length()) continue;
                stringBuilder.append('\n').append("[...]");
                break;
            }
        }
        if (null != this.actionsForClient) {
            stringBuilder.append("Actions for client:\n");
            for (AbstractAction<T> action : this.actionsForClient) {
                stringBuilder.append("  ").append(action).append('\n');
                if (100000 >= stringBuilder.length()) continue;
                stringBuilder.append('\n').append("[...]");
                break;
            }
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionsForClient == null ? 0 : ((Object)this.actionsForClient).hashCode());
        result = 31 * result + (this.actionsForServer == null ? 0 : ((Object)this.actionsForServer).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntermediateSyncResult)) {
            return false;
        }
        IntermediateSyncResult other = (IntermediateSyncResult)obj;
        if (this.actionsForClient == null ? other.actionsForClient != null : !((Object)this.actionsForClient).equals(other.actionsForClient)) {
            return false;
        }
        return !(this.actionsForServer == null ? other.actionsForServer != null : !((Object)this.actionsForServer).equals(other.actionsForServer));
    }
}

