/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync;

import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.actions.AcknowledgeFileAction;
import com.openexchange.drive.actions.DownloadFileAction;
import com.openexchange.drive.actions.EditFileAction;
import com.openexchange.drive.actions.ErrorFileAction;
import com.openexchange.drive.actions.RemoveFileAction;
import com.openexchange.drive.actions.UploadFileAction;
import com.openexchange.drive.comparison.Change;
import com.openexchange.drive.comparison.ServerFileVersion;
import com.openexchange.drive.comparison.ThreeWayComparison;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.PathNormalizer;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.internal.UploadHelper;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.RenameTools;
import com.openexchange.drive.sync.SimpleFileVersion;
import com.openexchange.drive.sync.Synchronizer;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStoragePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FileSynchronizer
extends Synchronizer<FileVersion> {
    private Set<String> usedFilenames;
    private List<UploadFileAction> uploadActions;
    private final String path;
    private FileStoragePermission folderPermission;
    private Set<String> normalizedDirectoryNames;

    public FileSynchronizer(SyncSession session, VersionMapper<FileVersion> mapper, String path) throws OXException {
        super(session, mapper);
        this.path = path;
    }

    @Override
    public IntermediateSyncResult<FileVersion> sync() throws OXException {
        this.usedFilenames = new HashSet<String>(this.mapper.getKeys());
        this.uploadActions = new ArrayList<UploadFileAction>();
        IntermediateSyncResult<FileVersion> syncResult = super.sync();
        if (0 < this.uploadActions.size()) {
            ArrayList<FileVersion> versionsToUpload = new ArrayList<FileVersion>(this.uploadActions.size());
            for (UploadFileAction uploadAction : this.uploadActions) {
                versionsToUpload.add((FileVersion)uploadAction.getNewVersion());
            }
            List<Long> uploadOffsets = new UploadHelper(this.session).getUploadOffsets(this.path, versionsToUpload);
            for (int i = 0; i < uploadOffsets.size(); ++i) {
                this.uploadActions.get(i).getParameters().put("offset", uploadOffsets.get(i));
            }
        }
        if (null != this.mapper.getMappingProblems().getCaseConflictingClientVersions()) {
            for (FileVersion clientVersion : this.mapper.getMappingProblems().getCaseConflictingClientVersions()) {
                FileVersion renamedVersion = this.getRenamedVersion(this.session, clientVersion);
                ThreeWayComparison<FileVersion> twc = new ThreeWayComparison<FileVersion>();
                twc.setClientVersion(clientVersion);
                syncResult.addActionForClient(new EditFileAction(clientVersion, renamedVersion, twc, this.path, false));
                if (this.mayCreate()) {
                    UploadFileAction uploadAction = new UploadFileAction(null, renamedVersion, twc, this.path, 0L);
                    this.uploadActions.add(uploadAction);
                    syncResult.addActionForClient(uploadAction);
                    continue;
                }
                OXException e = DriveExceptionCodes.NO_CREATE_FILE_PERMISSION.create(this.path);
                LOG.warn("Client upload not allowed for {}", (Object)clientVersion, (Object)e);
                syncResult.addActionForClient(new ErrorFileAction(clientVersion, renamedVersion, null, this.path, e, true));
            }
        }
        if (null != this.mapper.getMappingProblems().getUnicodeConflictingClientVersions()) {
            for (FileVersion clientVersion : this.mapper.getMappingProblems().getUnicodeConflictingClientVersions()) {
                ThreeWayComparison<FileVersion> twc = new ThreeWayComparison<FileVersion>();
                twc.setClientVersion(clientVersion);
                OXException e = DriveExceptionCodes.CONFLICTING_FILENAME.create(clientVersion.getName());
                LOG.warn("Client upload not allowed due to unicode conflicts: {}", (Object)clientVersion, (Object)e);
                syncResult.addActionForClient(new ErrorFileAction(null, clientVersion, twc, this.path, e, true));
            }
        }
        return syncResult;
    }

    @Override
    protected int getMaxActions() {
        return DriveConfig.getInstance().getMaxFileActions();
    }

    @Override
    protected int processServerChange(IntermediateSyncResult<FileVersion> result, ThreeWayComparison<FileVersion> comparison) throws OXException {
        switch (comparison.getServerChange()) {
            case DELETED: {
                result.addActionForClient(new RemoveFileAction(comparison.getClientVersion(), comparison, this.path));
                return 1;
            }
            case MODIFIED: {
                if (comparison.getServerVersion().getChecksum().equalsIgnoreCase(comparison.getClientVersion().getChecksum()) && comparison.getServerVersion().getName().equalsIgnoreCase(comparison.getClientVersion().getName()) && !comparison.getServerVersion().getName().equals(comparison.getClientVersion().getName())) {
                    result.addActionForClient(new EditFileAction(comparison.getClientVersion(), comparison.getServerVersion(), comparison, this.path));
                    return 1;
                }
                result.addActionForClient(new DownloadFileAction(this.session, comparison.getClientVersion(), ServerFileVersion.valueOf(comparison.getServerVersion(), this.path, this.session), comparison, this.path));
                return 1;
            }
            case NEW: {
                result.addActionForClient(new DownloadFileAction(this.session, comparison.getClientVersion(), ServerFileVersion.valueOf(comparison.getServerVersion(), this.path, this.session), comparison, this.path));
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected int processClientChange(IntermediateSyncResult<FileVersion> result, ThreeWayComparison<FileVersion> comparison) throws OXException {
        switch (comparison.getClientChange()) {
            case DELETED: {
                if (this.mayDelete(comparison.getServerVersion())) {
                    result.addActionForServer(new RemoveFileAction(comparison.getServerVersion(), comparison, this.path));
                    result.addActionForClient(new AcknowledgeFileAction(this.session, comparison.getOriginalVersion(), null, comparison, this.path));
                    return 1;
                }
                OXException e = DriveExceptionCodes.NO_DELETE_FILE_PERMISSION.create(comparison.getServerVersion().getName(), this.path);
                LOG.warn("Client change refused for {}", (Object)comparison.getServerVersion(), (Object)e);
                result.addActionForClient(new DownloadFileAction(this.session, comparison.getClientVersion(), ServerFileVersion.valueOf(comparison.getServerVersion(), this.path, this.session), comparison, this.path));
                result.addActionForClient(new ErrorFileAction(comparison.getClientVersion(), comparison.getServerVersion(), comparison, this.path, e, false));
                return 2;
            }
            case MODIFIED: {
                if (this.mayModify(comparison.getServerVersion())) {
                    if (comparison.getClientVersion().getChecksum().equalsIgnoreCase(comparison.getServerVersion().getChecksum()) && comparison.getClientVersion().getName().equalsIgnoreCase(comparison.getServerVersion().getName()) && !comparison.getClientVersion().getName().equals(comparison.getServerVersion().getName())) {
                        ServerFileVersion serverFileVersion = ServerFileVersion.valueOf(comparison.getServerVersion(), this.path, this.session);
                        EditFileAction serverEdit = new EditFileAction(serverFileVersion, comparison.getClientVersion(), comparison, this.path);
                        AcknowledgeFileAction clientAcknowledge = new AcknowledgeFileAction(this.session, comparison.getOriginalVersion(), comparison.getClientVersion(), comparison, this.path, serverFileVersion.getFile());
                        clientAcknowledge.setDependingAction(serverEdit);
                        result.addActionForServer(serverEdit);
                        result.addActionForClient(clientAcknowledge);
                        return 1;
                    }
                    UploadFileAction uploadAction = new UploadFileAction(comparison.getServerVersion(), comparison.getClientVersion(), comparison, this.path, 0L);
                    this.uploadActions.add(uploadAction);
                    result.addActionForClient(uploadAction);
                    return 1;
                }
                if (this.mayCreate()) {
                    FileVersion renamedVersion = this.getRenamedVersion(this.session, comparison.getClientVersion());
                    result.addActionForClient(new EditFileAction(comparison.getClientVersion(), renamedVersion, comparison, this.path, false));
                    OXException e = DriveExceptionCodes.NO_MODIFY_FILE_PERMISSION.create(comparison.getServerVersion().getName(), this.path);
                    LOG.warn("Client change refused for {}", (Object)comparison.getServerVersion(), (Object)e);
                    result.addActionForClient(new ErrorFileAction(comparison.getClientVersion(), comparison.getServerVersion(), comparison, this.path, e, false));
                    UploadFileAction uploadAction = new UploadFileAction(null, renamedVersion, comparison, this.path, 0L);
                    this.uploadActions.add(uploadAction);
                    result.addActionForClient(uploadAction);
                    result.addActionForClient(new DownloadFileAction(this.session, null, ServerFileVersion.valueOf(comparison.getServerVersion(), this.path, this.session), comparison, this.path));
                    return 4;
                }
                FileVersion renamedVersion = this.getRenamedVersion(this.session, comparison.getClientVersion());
                result.addActionForClient(new EditFileAction(comparison.getClientVersion(), renamedVersion, comparison, this.path));
                result.addActionForClient(new ErrorFileAction(comparison.getClientVersion(), renamedVersion, comparison, this.path, DriveExceptionCodes.NO_MODIFY_FILE_PERMISSION.create(comparison.getServerVersion().getName(), this.path), true));
                result.addActionForClient(new DownloadFileAction(this.session, null, ServerFileVersion.valueOf(comparison.getServerVersion(), this.path, this.session), comparison, this.path));
                return 3;
            }
            case NEW: {
                if (this.mayCreate()) {
                    if (DriveUtils.isInvalidFileName(comparison.getClientVersion().getName())) {
                        result.addActionForClient(new ErrorFileAction(null, comparison.getClientVersion(), comparison, this.path, DriveExceptionCodes.INVALID_FILENAME.create(comparison.getClientVersion().getName()), true));
                        return 1;
                    }
                    if (DriveUtils.isIgnoredFileName(this.session.getDriveSession(), this.path, comparison.getClientVersion().getName())) {
                        result.addActionForClient(new ErrorFileAction(null, comparison.getClientVersion(), comparison, this.path, DriveExceptionCodes.IGNORED_FILENAME.create(comparison.getClientVersion().getName()), true));
                        return 1;
                    }
                    if (this.getNormalizedDirectoryNames().contains(PathNormalizer.normalize(comparison.getClientVersion().getName()))) {
                        result.addActionForClient(new ErrorFileAction(null, comparison.getClientVersion(), comparison, this.path, DriveExceptionCodes.LEVEL_CONFLICTING_FILENAME.create(comparison.getClientVersion().getName(), this.path), true));
                        return 1;
                    }
                    UploadFileAction uploadAction = new UploadFileAction(comparison.getServerVersion(), comparison.getClientVersion(), comparison, this.path, 0L);
                    this.uploadActions.add(uploadAction);
                    result.addActionForClient(uploadAction);
                    return 1;
                }
                result.addActionForClient(new ErrorFileAction(null, comparison.getClientVersion(), comparison, this.path, DriveExceptionCodes.NO_CREATE_FILE_PERMISSION.create(this.path), true));
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected int processConflictingChange(IntermediateSyncResult<FileVersion> result, ThreeWayComparison<FileVersion> comparison) throws OXException {
        if (Change.DELETED == comparison.getServerChange() && Change.DELETED == comparison.getClientChange()) {
            result.addActionForClient(new AcknowledgeFileAction(this.session, comparison.getOriginalVersion(), null, comparison, this.path));
            return 0;
        }
        if (!(Change.NEW != comparison.getClientChange() && Change.MODIFIED != comparison.getClientChange() || Change.NEW != comparison.getServerChange() && Change.MODIFIED != comparison.getServerChange())) {
            if (Change.NONE.equals((Object)Change.get(comparison.getClientVersion(), comparison.getServerVersion()))) {
                ServerFileVersion serverFileVersion = ServerFileVersion.valueOf(comparison.getServerVersion(), this.path, this.session);
                result.addActionForClient(new AcknowledgeFileAction(this.session, comparison.getOriginalVersion(), comparison.getClientVersion(), comparison, this.path, serverFileVersion.getFile()));
                return 0;
            }
            if (comparison.getClientVersion().getChecksum().equalsIgnoreCase(comparison.getServerVersion().getChecksum()) && comparison.getClientVersion().getName().equalsIgnoreCase(comparison.getServerVersion().getName()) && !comparison.getClientVersion().getName().equals(comparison.getServerVersion().getName())) {
                result.addActionForClient(new EditFileAction(comparison.getClientVersion(), comparison.getServerVersion(), comparison, this.path));
                return 1;
            }
            FileVersion renamedVersion = this.getRenamedVersion(this.session, comparison.getClientVersion());
            result.addActionForClient(new EditFileAction(comparison.getClientVersion(), renamedVersion, comparison, this.path, false));
            if (this.mayCreate()) {
                UploadFileAction uploadAction = new UploadFileAction(null, renamedVersion, comparison, this.path, 0L);
                this.uploadActions.add(uploadAction);
                result.addActionForClient(uploadAction);
            } else {
                OXException e = DriveExceptionCodes.NO_CREATE_FILE_PERMISSION.create(this.path);
                LOG.warn("Client upload not allowed for {}", (Object)comparison.getClientVersion(), (Object)e);
                result.addActionForClient(new ErrorFileAction(comparison.getClientVersion(), renamedVersion, comparison, this.path, e, true));
            }
            File serverFile = ServerFileVersion.valueOf(comparison.getServerVersion(), this.path, this.session).getFile();
            result.addActionForClient(new DownloadFileAction(this.session, null, comparison.getServerVersion(), comparison, this.path, serverFile));
            return 3;
        }
        if (Change.DELETED == comparison.getClientChange() && (Change.MODIFIED == comparison.getServerChange() || Change.NEW == comparison.getServerChange())) {
            File serverFile = ServerFileVersion.valueOf(comparison.getServerVersion(), this.path, this.session).getFile();
            result.addActionForClient(new DownloadFileAction(this.session, null, comparison.getServerVersion(), comparison, this.path, serverFile));
            return 1;
        }
        if ((Change.NEW == comparison.getClientChange() || Change.MODIFIED == comparison.getClientChange()) && Change.DELETED == comparison.getServerChange()) {
            if (this.mayCreate()) {
                UploadFileAction uploadAction = new UploadFileAction(null, comparison.getClientVersion(), comparison, this.path, 0L);
                result.addActionForClient(uploadAction);
                this.uploadActions.add(uploadAction);
                return 1;
            }
            result.addActionForClient(new ErrorFileAction(null, comparison.getClientVersion(), comparison, this.path, DriveExceptionCodes.NO_CREATE_FILE_PERMISSION.create(this.path), true));
            return 1;
        }
        throw new UnsupportedOperationException("Not implemented: Server: " + (Object)((Object)comparison.getServerChange()) + ", Client: " + (Object)((Object)comparison.getClientChange()));
    }

    private boolean mayDelete(FileVersion version) throws OXException {
        int deletePermission = this.getPermission().getDeletePermission();
        if (4 <= deletePermission) {
            return true;
        }
        if (2 > deletePermission) {
            return false;
        }
        if (2 == deletePermission) {
            ServerFileVersion serverFileVersion = ServerFileVersion.valueOf(version, this.path, this.session);
            return serverFileVersion.getFile().getCreatedBy() == this.session.getServerSession().getUserId();
        }
        throw new UnsupportedOperationException("unknown permission: " + deletePermission);
    }

    protected FileVersion getRenamedVersion(SyncSession session, FileVersion conflictingVersion) {
        String alternativeName = RenameTools.findAlternativeName(conflictingVersion.getName(), this.usedFilenames, session.getDeviceName());
        if (null != this.usedFilenames) {
            this.usedFilenames.add(alternativeName);
        }
        return new SimpleFileVersion(alternativeName, conflictingVersion.getChecksum());
    }

    private boolean mayCreate() throws OXException {
        FileStoragePermission permission = this.getPermission();
        return 4 <= permission.getFolderPermission() && 2 <= permission.getWritePermission();
    }

    private boolean mayModify(FileVersion version) throws OXException {
        int writePermission = this.getPermission().getWritePermission();
        if (4 <= writePermission) {
            return true;
        }
        if (2 > writePermission) {
            return false;
        }
        if (2 == writePermission) {
            ServerFileVersion serverFileVersion = ServerFileVersion.valueOf(version, this.path, this.session);
            return serverFileVersion.getFile().getCreatedBy() == this.session.getServerSession().getUserId();
        }
        throw new UnsupportedOperationException("unknown permission: " + writePermission);
    }

    private FileStoragePermission getPermission() throws OXException {
        if (null == this.folderPermission) {
            this.folderPermission = this.session.getStorage().getOwnPermission(this.path);
        }
        return this.folderPermission;
    }

    private Set<String> getNormalizedDirectoryNames() throws OXException {
        if (null == this.normalizedDirectoryNames) {
            this.normalizedDirectoryNames = DriveUtils.getNormalizedFolderNames(this.session.getStorage().getSubfolders(this.path).values());
        }
        return this.normalizedDirectoryNames;
    }
}

