/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync;

import com.openexchange.drive.DriveAction;
import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.SyncResult;
import com.openexchange.drive.actions.AbstractAction;
import java.util.ArrayList;
import java.util.List;

public class DefaultSyncResult<T extends DriveVersion>
implements SyncResult<T> {
    private final List<DriveAction<T>> actionsForClient;
    private final String diagnosticsLog;

    public DefaultSyncResult(List<AbstractAction<T>> actionsForClient, String diagnosticsLog) {
        this.actionsForClient = new ArrayList<DriveAction<T>>(actionsForClient.size());
        for (AbstractAction<T> driveAction : actionsForClient) {
            this.actionsForClient.add(driveAction);
        }
        this.diagnosticsLog = diagnosticsLog;
    }

    @Override
    public List<DriveAction<T>> getActionsForClient() {
        return this.actionsForClient;
    }

    @Override
    public String getDiagnostics() {
        return this.diagnosticsLog;
    }

    public String toString() {
        StringBuilder StringBuilder2 = new StringBuilder();
        if (null != this.actionsForClient) {
            StringBuilder2.append("Actions for client:\n");
            for (DriveAction<T> action : this.actionsForClient) {
                StringBuilder2.append("  ").append(action).append('\n');
            }
        }
        return StringBuilder2.toString();
    }
}

