/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.storage;

import com.openexchange.drive.internal.PathNormalizer;
import com.openexchange.file.storage.FileStorageFolder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FolderCache {
    private final Map<String, String> knownPaths;
    private final Map<String, FileStorageFolder> knownFolders = new HashMap<String, FileStorageFolder>();

    public FolderCache() {
        this.knownPaths = new HashMap<String, String>();
    }

    public String getPath(String folderID) {
        return this.knownPaths.get(folderID);
    }

    public FileStorageFolder getFolder(String path) {
        return this.knownFolders.get(PathNormalizer.normalize(path));
    }

    public void remember(String path, FileStorageFolder folder) {
        this.knownPaths.put(folder.getId(), PathNormalizer.normalize(path));
        this.knownFolders.put(PathNormalizer.normalize(path), folder);
    }

    public void forget(String path, FileStorageFolder folder, boolean forgetSubfolders) {
        this.knownPaths.remove(folder.getId());
        this.knownFolders.remove(PathNormalizer.normalize(path));
        if (forgetSubfolders) {
            Iterator<Map.Entry<String, FileStorageFolder>> iterator = this.knownFolders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, FileStorageFolder> knownFolder = iterator.next();
                if (!knownFolder.getKey().startsWith(PathNormalizer.normalize(path))) continue;
                this.knownPaths.remove(knownFolder.getValue().getId());
                iterator.remove();
            }
        }
    }
}

