/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.storage;

import com.openexchange.drive.DriveConstants;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.drive.internal.PathNormalizer;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.drive.storage.FolderCache;
import com.openexchange.drive.storage.StorageOperation;
import com.openexchange.drive.storage.filter.FileNameFilter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.DefaultFileStorageFolder;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderType;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.Quota;
import com.openexchange.file.storage.TypeAware;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.file.storage.search.FileNameTerm;
import com.openexchange.file.storage.search.SearchTerm;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Strings;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DriveStorage {
    private final FolderID rootFolderID;
    private final SyncSession session;
    private final FolderCache knownFolders;
    private IDBasedFileAccess fileAccess;
    private IDBasedFolderAccess folderAccess;
    private FileStorageFolder trashFolder;
    private Boolean hasTrashFolder;

    public DriveStorage(SyncSession session) {
        this.session = session;
        this.rootFolderID = new FolderID(session.getRootFolderID());
        this.knownFolders = new FolderCache();
    }

    public FileStoragePermission getOwnPermission(String path) throws OXException {
        return this.getFolder(path).getOwnPermission();
    }

    public <T> T wrapInTransaction(StorageOperation<T> storageOperation) throws OXException {
        try {
            this.getFileAccess().startTransaction();
            this.getFolderAccess().startTransaction();
            T t = storageOperation.call();
            this.getFileAccess().commit();
            this.getFolderAccess().commit();
            T t2 = t;
            return t2;
        }
        catch (OXException e) {
            this.getFileAccess().rollback();
            this.getFolderAccess().rollback();
            throw e;
        }
        finally {
            this.getFileAccess().finish();
            this.getFolderAccess().finish();
        }
    }

    public Quota[] getQuota() throws OXException {
        return this.getFolderAccess().getQuotas(this.rootFolderID.toUniqueID(), new Quota.Type[]{Quota.Type.STORAGE, Quota.Type.FILE});
    }

    public File copyFile(File sourceFile, String targetFileName, String targetPath) throws OXException {
        DefaultFile copiedFile = new DefaultFile();
        copiedFile.setFileName(targetFileName);
        copiedFile.setTitle(targetFileName);
        copiedFile.setFolderId(this.getFolderID(targetPath, true));
        copiedFile.setLastModified(new Date());
        copiedFile.setVersion("1");
        copiedFile.setFileMIMEType(sourceFile.getFileMIMEType());
        List<File.Field> fileFields = Arrays.asList(File.Field.FILENAME, File.Field.TITLE, File.Field.FOLDER_ID, File.Field.LAST_MODIFIED, File.Field.VERSION);
        if (this.session.isTraceEnabled()) {
            this.session.trace(this.toString() + "cp " + DriveStorage.combine(this.getPath(sourceFile.getFolderId()), sourceFile.getFileName()) + " " + DriveStorage.combine(targetPath, targetFileName));
        }
        String sourceVersion = sourceFile.isCurrentVersion() ? FileStorageFileAccess.CURRENT_VERSION : sourceFile.getVersion();
        String targetId = this.getFileAccess().copy(sourceFile.getId(), sourceVersion, copiedFile.getFolderId(), (File)copiedFile, null, fileFields);
        copiedFile.setId(targetId);
        return copiedFile;
    }

    public File copyFile(File sourceFile, File targetFile) throws OXException {
        DefaultFile copiedFile = new DefaultFile(targetFile);
        copiedFile.setLastModified(new Date());
        copiedFile.setFileSize(sourceFile.getFileSize());
        copiedFile.setFileMD5Sum(sourceFile.getFileMD5Sum());
        copiedFile.setFileMIMEType(sourceFile.getFileMIMEType());
        if (this.session.isTraceEnabled()) {
            this.session.trace(this.toString() + "cp " + DriveStorage.combine(this.getPath(sourceFile.getFolderId()), sourceFile.getFileName()) + " " + DriveStorage.combine(this.getPath(copiedFile.getFolderId()), copiedFile.getFileName()));
        }
        this.getFileAccess().saveDocument((File)copiedFile, this.getDocument(sourceFile), copiedFile.getSequenceNumber());
        return copiedFile;
    }

    public File moveFile(File sourceFile, File targetFile) throws OXException {
        File copiedFile = this.copyFile(sourceFile, targetFile);
        this.deleteFile(sourceFile);
        return copiedFile;
    }

    public File deleteFile(File file) throws OXException {
        return this.deleteFile(file, false);
    }

    public File deleteFile(File file, boolean hardDelete) throws OXException {
        List notRemoved;
        if (this.session.isTraceEnabled()) {
            this.session.trace(this.toString() + "rm " + (hardDelete ? "-rf " : "") + DriveStorage.combine(this.getPath(file.getFolderId()), file.getFileName()));
        }
        if (null != (notRemoved = this.getFileAccess().removeDocument(Arrays.asList(file.getId()), file.getSequenceNumber(), hardDelete)) && 0 < notRemoved.size()) {
            throw DriveExceptionCodes.FILE_NOT_FOUND.create(file.getFileName(), this.getPath(file.getFolderId()));
        }
        return file;
    }

    public List<File> deleteFiles(List<File> files, boolean hardDelete) throws OXException {
        List notRemoved;
        HashMap<String, File> ids = new HashMap<String, File>(files.size());
        long sequenceNumber = 0L;
        StringBuilder StringBuilder2 = this.session.isTraceEnabled() ? new StringBuilder() : null;
        for (File file : files) {
            ids.put(file.getId(), file);
            sequenceNumber = Math.max(sequenceNumber, file.getSequenceNumber());
            if (null == StringBuilder2) continue;
            StringBuilder2.append(' ').append(DriveStorage.combine(this.getPath(file.getFolderId()), file.getFileName()));
        }
        if (null != StringBuilder2) {
            this.session.trace(this.toString() + "rm" + (hardDelete ? " -rf " : "") + StringBuilder2.toString());
        }
        if (null == (notRemoved = this.getFileAccess().removeDocument(new ArrayList(ids.keySet()), sequenceNumber, hardDelete)) || 0 == notRemoved.size()) {
            return Collections.emptyList();
        }
        ArrayList<File> notRemovedFiles = new ArrayList<File>(notRemoved.size());
        for (String id : notRemoved) {
            notRemovedFiles.add((File)ids.get(id));
        }
        return notRemovedFiles;
    }

    public File renameFile(File file, String targetFileName) throws OXException {
        return this.moveFile(file, targetFileName, null);
    }

    public File moveFile(File file, String targetPath) throws OXException {
        return this.moveFile(file, null, targetPath);
    }

    public File moveFile(File file, String targetFileName, String targetPath) throws OXException {
        ArrayList<File.Field> updatedFields = new ArrayList<File.Field>();
        DefaultFile movedFile = new DefaultFile(file);
        if (null != targetFileName && !targetFileName.equals(file.getFileName())) {
            movedFile.setFileName(targetFileName);
            updatedFields.add(File.Field.FILENAME);
            if (null != file.getTitle() && file.getTitle().equals(file.getFileName())) {
                movedFile.setTitle(targetFileName);
                updatedFields.add(File.Field.TITLE);
            }
        }
        if (null != targetPath) {
            String targetFolderID = this.getFolderID(targetPath, true);
            if (!file.getFolderId().equals(targetFolderID)) {
                movedFile.setFolderId(targetFolderID);
                updatedFields.add(File.Field.FOLDER_ID);
            }
            FileStorageFolder targetFolder = this.getFolder(targetPath, true);
            if (!file.getFolderId().equals(targetFolder.getId())) {
                movedFile.setFolderId(targetFolder.getId());
                updatedFields.add(File.Field.FOLDER_ID);
            }
        }
        if (0 < updatedFields.size()) {
            if (this.session.isTraceEnabled()) {
                this.session.trace(this.toString() + "mv " + DriveStorage.combine(this.getPath(file.getFolderId()), file.getFileName()) + " " + DriveStorage.combine(this.getPath(movedFile.getFolderId()), movedFile.getFileName()));
            }
            this.getFileAccess().saveFileMetadata((File)movedFile, file.getSequenceNumber(), updatedFields);
        }
        return movedFile;
    }

    public File createFile(String path, String fileName) throws OXException {
        return this.createFile(path, fileName, null, null);
    }

    public File createFile(String path, String fileName, File additionalMetadata, InputStream data) throws OXException {
        DefaultFile file = null != additionalMetadata ? new DefaultFile(additionalMetadata) : new DefaultFile();
        file.setFolderId(this.getFolderID(path, true));
        file.setFileName(fileName);
        if (this.session.isTraceEnabled()) {
            this.session.trace(this.toString() + "touch " + DriveStorage.combine(path, fileName));
        }
        if (null == data) {
            this.getFileAccess().saveFileMetadata((File)file, -1L);
        } else {
            this.getFileAccess().saveDocument((File)file, data, -1L);
        }
        return file;
    }

    public String moveFolder(String path, String newPath) throws OXException {
        if (Strings.isEmpty((String)newPath) || "/".equals(newPath)) {
            throw DriveExceptionCodes.INVALID_PATH.create(newPath);
        }
        if (Strings.isEmpty((String)path) || "/".equals(path)) {
            throw DriveExceptionCodes.INVALID_PATH.create(path);
        }
        FileStorageFolder folder = this.getFolder(path);
        String folderID = folder.getId();
        this.knownFolders.forget(path, folder, true);
        int idx = path.lastIndexOf(47);
        String oldName = path.substring(idx + 1);
        String oldParentPath = 0 == idx ? "/" : path.substring(0, idx);
        idx = newPath.lastIndexOf(47);
        String newName = newPath.substring(idx + 1);
        String newParentPath = 0 == idx ? "/" : newPath.substring(0, idx);
        FileStorageFolder newParentFolder = this.getFolder(newParentPath, true);
        if (this.session.isTraceEnabled()) {
            this.session.trace(this.toString() + "mv " + path + " " + newPath);
        }
        if (!oldParentPath.equals(newParentPath)) {
            folderID = oldName.equals(newName) ? this.getFolderAccess().moveFolder(folderID, newParentFolder.getId()) : this.getFolderAccess().moveFolder(folderID, newParentFolder.getId(), newName);
        } else if (!oldName.equals(newName)) {
            folderID = this.getFolderAccess().renameFolder(folderID, newName);
        }
        return folderID;
    }

    public String createFolder(String path) throws OXException {
        return this.getFolderID(path, true);
    }

    public String deleteFolder(String path) throws OXException {
        return this.deleteFolder(path, false);
    }

    public String deleteFolder(String path, boolean hardDelete) throws OXException {
        if (Strings.isEmpty((String)path) || "/".equals(path)) {
            throw DriveExceptionCodes.INVALID_PATH.create(path);
        }
        FileStorageFolder folder = this.getFolder(path);
        this.knownFolders.forget(path, folder, true);
        if (this.session.isTraceEnabled()) {
            this.session.trace(this.toString() + "rmdir " + (hardDelete ? "-rf " : "") + path);
        }
        this.getFolderAccess().deleteFolder(folder.getId());
        return folder.getId();
    }

    public Map<String, Long> getSequenceNumbers(List<String> folderIDs) throws OXException {
        if (null == folderIDs || 0 == folderIDs.size()) {
            return Collections.emptyMap();
        }
        if (!this.supports(FileStorageCapability.SEQUENCE_NUMBERS)) {
            throw new UnsupportedOperationException("IDBasedSequenceNumberProvider is needed");
        }
        return this.getFileAccess().getSequenceNumbers(folderIDs);
    }

    public InputStream getDocument(File file) throws OXException {
        return this.getFileAccess().getDocument(file.getId(), file.getVersion());
    }

    public File getFile(String id) throws OXException {
        return this.getFile(id, FileStorageFileAccess.CURRENT_VERSION);
    }

    public File getFile(String id, String version) throws OXException {
        return this.getFileAccess().getFileMetadata(id, version);
    }

    public List<File> getFilesInFolder(String folderID) throws OXException {
        return this.getFilesInFolder(folderID, false, null, null);
    }

    public List<File> getFilesInFolder(String folderID, boolean all, String pattern, List<File.Field> fields) throws OXException {
        FileNameFilter filter;
        FileStorageFolder folder = this.getFolderAccess().getFolder(folderID);
        if (null == folder) {
            throw FileStorageExceptionCodes.FOLDER_NOT_FOUND.create(new Object[]{folderID, this.rootFolderID.getAccountId(), this.rootFolderID.getService(), this.session.getServerSession().getUserId(), this.session.getServerSession().getContextId()});
        }
        if (null == folder.getOwnPermission() || 2 > folder.getOwnPermission().getReadPermission()) {
            return Collections.emptyList();
        }
        if (all) {
            filter = FileNameFilter.ACCEPT_ALL;
        } else {
            final String path = this.getPath(folderID);
            final Set<String> existingNames = DriveUtils.getNormalizedFolderNames(this.session.getStorage().getSubfolders(path).values());
            filter = new FileNameFilter(){

                @Override
                protected boolean accept(String fileName) throws OXException {
                    return false == DriveUtils.isInvalidFileName(fileName) && false == DriveUtils.isIgnoredFileName(DriveStorage.this.session.getDriveSession(), path, fileName) && false == existingNames.contains(PathNormalizer.normalize(fileName));
                }
            };
        }
        return filter.findAll(this.searchDocuments(folderID, pattern, null != fields ? fields : DriveConstants.FILE_FIELDS));
    }

    public File findFileByName(String path, String name) throws OXException {
        return this.findFileByName(path, name, false);
    }

    public File getFileByName(String path, String name) throws OXException {
        return this.getFileByName(path, name, false);
    }

    public File findFileByName(String path, String name, boolean normalizeFileNames) throws OXException {
        return this.findFileByName(path, name, DriveConstants.FILE_FIELDS, normalizeFileNames);
    }

    public File getFileByName(String path, String name, boolean normalizeFileNames) throws OXException {
        return this.getFileByName(path, name, DriveConstants.FILE_FIELDS, normalizeFileNames);
    }

    private File findFileByName(String path, String name, List<File.Field> fields, boolean normalizeFileNames) throws OXException {
        List<File> files = FileNameFilter.byName(name, normalizeFileNames).findAll(this.searchDocuments(this.getFolderID(path), name, fields));
        return DriveStorage.selectFile(files, name);
    }

    private File getFileByName(String path, String name, List<File.Field> fields, boolean normalizeFileNames) throws OXException {
        List<File> files = FileNameFilter.byName(name, normalizeFileNames).findAll(this.getDocuments(this.getFolderID(path), name, fields));
        return DriveStorage.selectFile(files, name);
    }

    private static File selectFile(List<File> files, String name) {
        if (null == files || 0 == files.size()) {
            return null;
        }
        if (1 == files.size()) {
            return files.get(0);
        }
        File normalizedFile = null;
        for (File file : files) {
            if (name.equals(file.getFileName())) {
                return file;
            }
            if (!PathNormalizer.isNormalized(file.getFileName())) continue;
            normalizedFile = file;
        }
        return null != normalizedFile ? normalizedFile : files.get(0);
    }

    public String getPath(String folderID) throws OXException {
        String path = this.knownFolders.getPath(folderID);
        if (null == path) {
            path = this.resolveToRoot(folderID);
        }
        return path;
    }

    public String getFolderID(String path) throws OXException {
        return this.getFolderID(path, false);
    }

    public String getFolderID(String path, boolean createIfNeeded) throws OXException {
        return this.getFolder(path, createIfNeeded).getId();
    }

    public FileStorageFolder getFolder(String path) throws OXException {
        return this.getFolder(path, false);
    }

    public boolean hasTrashFolder() throws OXException {
        if (null == this.hasTrashFolder) {
            try {
                this.hasTrashFolder = null != this.getTrashFolder();
            }
            catch (OXException e) {
                if (FileStorageExceptionCodes.NO_SUCH_FOLDER.equals(e)) {
                    this.hasTrashFolder = Boolean.FALSE;
                }
                throw e;
            }
        }
        return this.hasTrashFolder;
    }

    public FileStorageFolder getTrashFolder() throws OXException {
        if (null == this.trashFolder) {
            this.trashFolder = this.getFolderAccess().getTrashFolder(this.rootFolderID.toUniqueID());
        }
        return this.trashFolder;
    }

    public FileStorageFolder getFolder(String path, boolean createIfNeeded) throws OXException {
        FileStorageFolder folder = this.knownFolders.getFolder(path);
        if (null == folder) {
            folder = this.resolveToLeaf(path, createIfNeeded, true);
        }
        return folder;
    }

    public FileStorageFolder optFolder(String path, boolean createIfNeeded) throws OXException {
        FileStorageFolder folder = this.knownFolders.getFolder(path);
        if (null == folder) {
            folder = this.resolveToLeaf(path, createIfNeeded, false);
        }
        return folder;
    }

    public Map<String, FileStorageFolder> getFolders() throws OXException {
        HashMap<String, FileStorageFolder> folders = new HashMap<String, FileStorageFolder>();
        FileStorageFolder rootFolder = this.getRootFolder();
        folders.put("/", rootFolder);
        this.addSubfolders(folders, rootFolder, "/", true);
        return folders;
    }

    public Map<String, FileStorageFolder> getSubfolders(String path) throws OXException {
        HashMap<String, FileStorageFolder> folders = new HashMap<String, FileStorageFolder>();
        FileStorageFolder folder = this.getFolder(path);
        this.addSubfolders(folders, folder, path, false);
        return folders;
    }

    public String getVersionComment() {
        String device = Strings.isEmpty((String)this.session.getDeviceName()) ? this.session.getServerSession().getClient() : this.session.getDeviceName();
        String product = DriveConfig.getInstance().getShortProductName();
        String format = StringHelper.valueOf((Locale)this.session.getDriveSession().getLocale()).getString("Uploaded with %1$s (%2$s)");
        return String.format(format, product, device);
    }

    private SearchIterator<File> searchDocuments(String folderID, String pattern, List<File.Field> fields) throws OXException {
        if (null == pattern) {
            return this.getDocuments(folderID, fields);
        }
        return this.getFileAccess().search(pattern, null != fields ? fields : DriveConstants.FILE_FIELDS, folderID, null, FileStorageFileAccess.SortDirection.DEFAULT, -11, -11);
    }

    private SearchIterator<File> getDocuments(String folderID, String filename, List<File.Field> fields) throws OXException {
        if (null == filename) {
            return this.getDocuments(folderID, fields);
        }
        if (this.supports(FileStorageCapability.SEARCH_BY_TERM)) {
            return this.getFileAccess().search(Collections.singletonList(folderID), (SearchTerm)new FileNameTerm(filename, false, false), null != fields ? fields : DriveConstants.FILE_FIELDS, null, FileStorageFileAccess.SortDirection.DEFAULT, -11, -11);
        }
        return this.getFileAccess().search(filename, fields, folderID, null, FileStorageFileAccess.SortDirection.DEFAULT, -11, -11);
    }

    private SearchIterator<File> getDocuments(String folderID, List<File.Field> fields) throws OXException {
        return this.getFileAccess().getDocuments(folderID, null != fields ? fields : DriveConstants.FILE_FIELDS, null, FileStorageFileAccess.SortDirection.DEFAULT).results();
    }

    private FileStorageFolder resolveToLeaf(String path, boolean createIfNeeded, boolean throwOnAbsence) throws OXException {
        FileStorageFolder currentFolder = this.getRootFolder();
        String currentPath = "/";
        for (String name : DriveStorage.split(path)) {
            FileStorageFolder[] subfolders;
            String normalizedName = PathNormalizer.normalize(name);
            FileStorageFolder existingFolder = this.knownFolders.getFolder(currentPath + normalizedName);
            if (null == existingFolder && null != (subfolders = this.getFolderAccess().getSubfolders(currentFolder.getId(), false)) && 0 < subfolders.length) {
                for (FileStorageFolder folder : subfolders) {
                    String normalizedFolderName = PathNormalizer.normalize(folder.getName());
                    this.knownFolders.remember(currentPath + normalizedFolderName, folder);
                    if (!normalizedName.equalsIgnoreCase(normalizedFolderName)) continue;
                    existingFolder = folder;
                }
            }
            if (null == existingFolder) {
                if (!createIfNeeded) {
                    if (throwOnAbsence) {
                        throw DriveExceptionCodes.PATH_NOT_FOUND.create(path);
                    }
                    return null;
                }
                existingFolder = this.createFolder(currentFolder, name);
                this.knownFolders.remember(currentPath + normalizedName, existingFolder);
            }
            currentFolder = existingFolder;
            currentPath = currentPath + name + '/';
        }
        return currentFolder;
    }

    private String resolveToRoot(String folderID) throws OXException {
        FileStorageFolder folder;
        LinkedList<FileStorageFolder> folders = new LinkedList<FileStorageFolder>();
        String currentFolderID = folderID;
        do {
            folder = this.getFolderAccess().getFolder(currentFolderID);
            folders.addFirst(folder);
        } while (null != (currentFolderID = folder.getParentId()) && !"0".equals(currentFolderID) && !this.rootFolderID.toUniqueID().equals(currentFolderID));
        if (0 < folders.size() && this.rootFolderID.toUniqueID().equals(((FileStorageFolder)folders.getFirst()).getParentId())) {
            StringBuilder pathBuilder = new StringBuilder();
            for (int i = 0; i < folders.size(); ++i) {
                FileStorageFolder folder2 = (FileStorageFolder)folders.get(i);
                pathBuilder.append('/').append(PathNormalizer.normalize(folder2.getName()));
                this.knownFolders.remember(pathBuilder.toString(), folder2);
            }
            return pathBuilder.toString();
        }
        return null;
    }

    private void addSubfolders(Map<String, FileStorageFolder> folders, FileStorageFolder parent, String path, boolean recursive) throws OXException {
        FileStorageFolder[] subfolders;
        for (FileStorageFolder subfolder : subfolders = this.getFolderAccess().getSubfolders(parent.getId(), false)) {
            String name = PathNormalizer.normalize(subfolder.getName());
            String subPath = "/".equals(path) ? path + name : path + '/' + name;
            this.knownFolders.remember(subPath, subfolder);
            if (this.isExcludedSubfolder(subfolder, subPath)) continue;
            folders.put(subPath, subfolder);
            if (!recursive) continue;
            this.addSubfolders(folders, subfolder, subPath, true);
        }
    }

    private boolean isExcludedSubfolder(FileStorageFolder folder, String path) throws OXException {
        String trashFolderID;
        if ("/.drive".equals(path)) {
            return true;
        }
        if (TypeAware.class.isInstance(folder) && FileStorageFolderType.TRASH_FOLDER.equals((Object)((TypeAware)folder).getType())) {
            return true;
        }
        String string = trashFolderID = this.hasTrashFolder() && null != this.getTrashFolder() ? this.getTrashFolder().getId() : null;
        return null != trashFolderID && trashFolderID.equals(folder.getId());
    }

    private FileStorageFolder getRootFolder() throws OXException {
        FileStorageFolder rootFolder = this.knownFolders.getFolder("/");
        if (null == rootFolder) {
            rootFolder = this.getFolderAccess().getFolder(this.rootFolderID.toUniqueID());
            this.knownFolders.remember("/", rootFolder);
        }
        return rootFolder;
    }

    private FileStorageFolder createFolder(FileStorageFolder parent, String name) throws OXException {
        DefaultFileStorageFolder newFolder = new DefaultFileStorageFolder();
        newFolder.setName(name);
        newFolder.setParentId(parent.getId());
        newFolder.setSubscribed(parent.isSubscribed());
        for (FileStoragePermission permission : parent.getPermissions()) {
            newFolder.addPermission(permission);
        }
        if (this.session.isTraceEnabled()) {
            this.session.trace(this.toString() + "mkdir " + DriveStorage.combine(this.getPath(parent.getId()), name));
        }
        String newFolderID = this.getFolderAccess().createFolder((FileStorageFolder)newFolder);
        return this.getFolderAccess().getFolder(newFolderID);
    }

    public static LinkedList<String> split(String path) throws OXException {
        if (null == path || !path.startsWith("/")) {
            throw DriveExceptionCodes.INVALID_PATH.create(path);
        }
        LinkedList<String> names = new LinkedList<String>();
        for (String name : path.split(String.valueOf('/'))) {
            if (Strings.isEmpty((String)name)) continue;
            names.addLast(name);
        }
        return names;
    }

    public static String combine(String path1, String path2) {
        if (Strings.isEmpty((String)path1)) {
            return path2;
        }
        if (Strings.isEmpty((String)path2)) {
            return path1;
        }
        if (path1.endsWith("/")) {
            return path2.startsWith("/") ? path1 + path2.substring(1) : path1 + path2;
        }
        return path2.startsWith("/") ? path1 + path2 : path1 + '/' + path2;
    }

    public IDBasedFolderAccess getFolderAccess() throws OXException {
        if (null == this.folderAccess) {
            IDBasedFolderAccessFactory factory = DriveServiceLookup.getService(IDBasedFolderAccessFactory.class, true);
            this.folderAccess = factory.createAccess((Session)this.session.getServerSession());
        }
        return this.folderAccess;
    }

    public IDBasedFileAccess getFileAccess() throws OXException {
        if (null == this.fileAccess) {
            IDBasedFileAccessFactory factory = DriveServiceLookup.getService(IDBasedFileAccessFactory.class, true);
            this.fileAccess = factory.createAccess((Session)this.session.getServerSession());
        }
        return this.fileAccess;
    }

    public boolean supports(FileStorageCapability ... capabilities) throws OXException {
        return this.getFileAccess().supports(this.rootFolderID.getService(), this.rootFolderID.getAccountId(), capabilities);
    }

    public String toString() {
        return this.session.getServerSession().getLogin() + ':' + this.rootFolderID.toUniqueID() + "# ";
    }
}

