/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.osgi;

import com.openexchange.capabilities.CapabilityService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.database.CreateTableService;
import com.openexchange.database.DatabaseService;
import com.openexchange.drive.DriveService;
import com.openexchange.drive.checksum.events.DelayedChecksumEventListener;
import com.openexchange.drive.checksum.rdb.DriveCreateTableService;
import com.openexchange.drive.checksum.rdb.DriveDeleteListener;
import com.openexchange.drive.checksum.rdb.SQL;
import com.openexchange.drive.internal.DriveServiceImpl;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.drive.internal.throttle.BucketInputStream;
import com.openexchange.drive.internal.throttle.DriveTokenBucket;
import com.openexchange.drive.internal.throttle.ThrottlingDriveService;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.groupware.update.DefaultUpdateTaskProviderService;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.server.ServiceLookup;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.timer.TimerService;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriveActivator
extends HousekeepingActivator {
    private static final Logger LOG = LoggerFactory.getLogger(DriveActivator.class);

    protected Class<?>[] getNeededServices() {
        return new Class[]{IDBasedFileAccessFactory.class, ManagedFileManagement.class, DatabaseService.class, CapabilityService.class, IDBasedFolderAccessFactory.class, EventAdmin.class, ConfigurationService.class, ThreadPoolService.class, TimerService.class};
    }

    protected void startBundle() throws Exception {
        LOG.info("starting bundle: \"com.openexchange.drive\"");
        DriveServiceLookup.set((ServiceLookup)this);
        DriveConfig.getInstance().start();
        BucketInputStream.setTokenBucket(new DriveTokenBucket());
        this.registerService(DriveService.class, new ThrottlingDriveService(new DriveServiceImpl()));
        this.registerService(CreateTableService.class, (Object)new DriveCreateTableService());
        this.registerService(UpdateTaskProviderService.class, new DefaultUpdateTaskProviderService(SQL.getUpdateTasks()));
        this.registerService(DeleteListener.class, new DriveDeleteListener());
        Hashtable<String, String[]> serviceProperties = new Hashtable<String, String[]>(1);
        ((Dictionary)serviceProperties).put("event.topics", DelayedChecksumEventListener.getHandledTopics());
        this.registerService(EventHandler.class, DelayedChecksumEventListener.getInstance(), serviceProperties);
        DelayedChecksumEventListener.getInstance().start();
    }

    protected void stopBundle() throws Exception {
        LOG.info("stopping bundle: \"com.openexchange.drive\"");
        BucketInputStream.setTokenBucket(null);
        DelayedChecksumEventListener.getInstance().stop();
        DriveConfig.getInstance().stop();
        DriveServiceLookup.set(null);
        super.stopBundle();
    }
}

