/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal.tracking;

import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.actions.ErrorDirectoryAction;
import com.openexchange.drive.actions.SyncDirectoriesAction;
import com.openexchange.drive.actions.SyncDirectoryAction;
import com.openexchange.drive.checksum.ChecksumProvider;
import com.openexchange.drive.checksum.DirectoryChecksum;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.internal.tracking.HistoryEntry;
import com.openexchange.drive.internal.tracking.RepeatedSequence;
import com.openexchange.drive.storage.execute.DirectoryActionExecutor;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.SimpleDirectoryVersion;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageFolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncTracker {
    private static final int MIN_REPETITION_COUNT = 3;
    private static final int MIN_SEQUENCE_LENGTH = 1;
    private static final int MAX_RESET_ATTEMPTS = 3;
    private static final List<HistoryEntry> IDLE_SEQUENCE = Arrays.asList(new HistoryEntry(new IntermediateSyncResult(new ArrayList(0), new ArrayList(0)), null).compact());
    private static final int MAX_HISTORY_SIZE = 50;
    private static final int MAX_HISTORY_ENTRY_LENGTH = 10;
    private static final String PARAM_RESULT_HISTORY = "com.openexchange.drive.resultHistory";
    private static final Logger LOG = LoggerFactory.getLogger(SyncTracker.class);
    private final SyncSession session;
    private ArrayList<HistoryEntry> resultHistory;

    public SyncTracker(SyncSession session) {
        this.session = session;
    }

    public IntermediateSyncResult<DirectoryVersion> trackAndCheck(IntermediateSyncResult<DirectoryVersion> syncResult) {
        this.insert(syncResult, null);
        RepeatedSequence<HistoryEntry> cycle = this.findCycle();
        if (null != cycle) {
            int resetAttempts;
            SyncTracker.trace(this.session, cycle);
            ArrayList optimizedActionsForClient = new ArrayList();
            ArrayList optimizedActionsForServer = new ArrayList();
            Collection<DirectoryVersion> affectedDirectoryVersions = SyncTracker.getAffectedDirectoryVersions(this.session, cycle);
            if (0 < affectedDirectoryVersions.size()) {
                for (DirectoryVersion directoryVersion : affectedDirectoryVersions) {
                    SyncDirectoryAction action = new SyncDirectoryAction(directoryVersion, null, true);
                    optimizedActionsForClient.add(action);
                }
                resetAttempts = this.getFrequency(new IntermediateSyncResult<DirectoryVersion>(optimizedActionsForServer, optimizedActionsForClient));
                if (1 == resetAttempts) {
                    this.session.trace("Cycle still detected after first attempt to reset directory checksums -resetting affected server checksums as well...");
                    SyncTracker.resetServerChecksums(this.session, affectedDirectoryVersions);
                } else if (3 <= resetAttempts) {
                    this.session.trace("Already tried to reset checksums " + resetAttempts + " times - adding 'qurantine' action for affected directories to interrupt further processing.");
                    optimizedActionsForClient.clear();
                    for (DirectoryVersion directoryVersion : affectedDirectoryVersions) {
                        OXException e = DriveExceptionCodes.REPEATED_SYNC_PROBLEMS.create(directoryVersion.getPath(), directoryVersion.getChecksum());
                        LOG.warn("Requesting client to stop synchronization: {}", (Object)this.session, (Object)e);
                        optimizedActionsForClient.add(new ErrorDirectoryAction(null, directoryVersion, null, e, false, true));
                    }
                }
            } else {
                optimizedActionsForClient.add(new SyncDirectoriesAction(true));
                resetAttempts = this.getFrequency(new IntermediateSyncResult<DirectoryVersion>(optimizedActionsForServer, optimizedActionsForClient));
                if (1 == resetAttempts) {
                    this.session.trace("Cycle still detected after first attempt to reset directory checksums -resetting affected server checksums as well...");
                    SyncTracker.resetServerChecksums(this.session, affectedDirectoryVersions);
                }
            }
            IntermediateSyncResult<DirectoryVersion> newResult = new IntermediateSyncResult<DirectoryVersion>(optimizedActionsForServer, optimizedActionsForClient);
            this.insert(newResult, null);
            if (this.session.isTraceEnabled()) {
                this.session.trace(newResult);
            }
            return newResult;
        }
        return syncResult;
    }

    public IntermediateSyncResult<FileVersion> track(IntermediateSyncResult<FileVersion> syncResult, String path) {
        this.insert(syncResult, path);
        return syncResult;
    }

    private HistoryEntry insert(IntermediateSyncResult<? extends DriveVersion> syncResult, String path) {
        HistoryEntry entry = new HistoryEntry(syncResult, path);
        ArrayList<HistoryEntry> history = this.getResultHistory();
        history.add(this.session.isTraceEnabled() && 10 >= syncResult.length() ? entry : entry.compact());
        if (50 < history.size()) {
            history.remove(0);
        }
        return entry;
    }

    private ArrayList<HistoryEntry> getResultHistory() {
        if (null == this.resultHistory) {
            this.resultHistory = SyncTracker.extractHistory(this.session);
        }
        return this.resultHistory;
    }

    private RepeatedSequence<HistoryEntry> findCycle() {
        ArrayList<HistoryEntry> history = this.getResultHistory();
        for (int i = 0; i < history.size(); ++i) {
            List<HistoryEntry> subList = history.subList(i, history.size());
            RepeatedSequence<HistoryEntry> repetitions = SyncTracker.findRepetitions(subList);
            if (null == repetitions || 3 > repetitions.getRepetitions() || null == repetitions.getSequence() || 1 > repetitions.getSequence().size() || ((Object)IDLE_SEQUENCE).equals(repetitions.getSequence())) continue;
            return repetitions;
        }
        return null;
    }

    private int getFrequency(IntermediateSyncResult<DirectoryVersion> result) {
        return Collections.frequency(this.getResultHistory(), new HistoryEntry(result, null));
    }

    private static Collection<DirectoryVersion> getAffectedDirectoryVersions(SyncSession session, RepeatedSequence<HistoryEntry> cycle) {
        HashMap<String, DirectoryVersion> directoryVersions = new HashMap<String, DirectoryVersion>();
        List<HistoryEntry> sequence = cycle.getSequence();
        for (HistoryEntry entry : sequence) {
            String path = entry.getPath();
            if (null == path || directoryVersions.containsKey(path)) continue;
            directoryVersions.put(path, SyncTracker.getDirectoryVersion(session, path));
        }
        return directoryVersions.values();
    }

    private static DirectoryVersion getDirectoryVersion(SyncSession session, String path) {
        try {
            List<DirectoryChecksum> checksums;
            FileStorageFolder folder = session.getStorage().optFolder(path, false);
            if (null != folder && null != (checksums = ChecksumProvider.getChecksums(session, Arrays.asList(folder.getId()))) && 1 == checksums.size()) {
                return new SimpleDirectoryVersion(path, checksums.get(0).getChecksum());
            }
        }
        catch (OXException e) {
            LOG.warn("Error getting directory version", (Throwable)e);
        }
        return new SimpleDirectoryVersion(path, "d41d8cd98f00b204e9800998ecf8427e");
    }

    private static void trace(SyncSession session, RepeatedSequence<HistoryEntry> cycle) {
        if (null != cycle && session.isTraceEnabled()) {
            List<HistoryEntry> sequence = cycle.getSequence();
            StringBuilder StringBuilder2 = new StringBuilder();
            StringBuilder2.append("A synchronization cycle was detected - the following ").append(sequence.size()).append(" sync results were repeated ").append(cycle.getRepetitions()).append(" times:\n\n");
            for (int i = 0; i < sequence.size(); ++i) {
                HistoryEntry entry = sequence.get(i);
                StringBuilder2.append(" # ").append(i + 1).append(' ').append(null != entry.getPath() ? entry.getPath() : "").append(" : [").append(entry.hashCode()).append("]\n");
                IntermediateSyncResult<? extends DriveVersion> result = entry.getSyncResult();
                if (null == result) continue;
                StringBuilder2.append(result);
            }
            session.trace(StringBuilder2.toString());
        }
    }

    private static <T> RepeatedSequence<T> findRepetitions(List<T> list) {
        if (null == list || 2 > list.size()) {
            return new RepeatedSequence<T>(list, 1);
        }
        ArrayList<T> currentSequence = new ArrayList<T>();
        currentSequence.add(list.get(0));
        int sequenceIndex = 0;
        int currentRepetitions = 1;
        for (int i = 1; i < list.size(); ++i) {
            T element = list.get(i);
            if (currentSequence.get(sequenceIndex).equals(element)) {
                if (++sequenceIndex < currentSequence.size()) continue;
                sequenceIndex = 0;
                ++currentRepetitions;
                continue;
            }
            ArrayList<Object> newSequence = new ArrayList<Object>();
            for (int r = 0; r < currentRepetitions; ++r) {
                newSequence.addAll(currentSequence);
            }
            newSequence.addAll(currentSequence.subList(0, sequenceIndex));
            newSequence.add(element);
            currentSequence = newSequence;
            sequenceIndex = 0;
            currentRepetitions = 1;
        }
        if (0 != sequenceIndex) {
            return new RepeatedSequence<T>(list, 1);
        }
        return new RepeatedSequence(currentSequence, currentRepetitions);
    }

    private static ArrayList<HistoryEntry> extractHistory(SyncSession session) {
        ArrayList<HistoryEntry> history;
        Object value = session.getServerSession().getParameter(PARAM_RESULT_HISTORY);
        if (null != value) {
            history = (ArrayList<HistoryEntry>)value;
        } else {
            history = new ArrayList<HistoryEntry>();
            session.getServerSession().setParameter(PARAM_RESULT_HISTORY, history);
        }
        return history;
    }

    private static void resetServerChecksums(SyncSession session, Collection<DirectoryVersion> directoryVersions) {
        ArrayList resetActions = new ArrayList();
        if (null == directoryVersions || 0 == directoryVersions.size()) {
            resetActions.add(new SyncDirectoriesAction(true));
        } else {
            for (DirectoryVersion directoryVersion : directoryVersions) {
                resetActions.add(new SyncDirectoryAction(directoryVersion, null, true));
            }
        }
        try {
            new DirectoryActionExecutor(session, true, true).execute(resetActions);
        }
        catch (OXException e) {
            LOG.warn("Error resetting server checksums", (Throwable)e);
        }
    }
}

