/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal.tracking;

import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.sync.IntermediateSyncResult;

public class HistoryEntry {
    private final IntermediateSyncResult<? extends DriveVersion> syncResult;
    private final int hashCode;
    private final String path;

    public HistoryEntry(IntermediateSyncResult<? extends DriveVersion> syncResult, String path) {
        this(syncResult, HistoryEntry.calculateHash(path, syncResult), path);
    }

    private HistoryEntry(IntermediateSyncResult<? extends DriveVersion> syncResult, int hashCode, String path) {
        this.syncResult = syncResult;
        this.path = path;
        this.hashCode = hashCode;
    }

    public String getPath() {
        return this.path;
    }

    public HistoryEntry compact() {
        return new HistoryEntry(null, this.hashCode, this.path);
    }

    public IntermediateSyncResult<? extends DriveVersion> getSyncResult() {
        return this.syncResult;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryEntry)) {
            return false;
        }
        HistoryEntry other = (HistoryEntry)obj;
        return this.hashCode == other.hashCode;
    }

    public String toString() {
        if (null == this.syncResult) {
            return String.valueOf(this.hashCode);
        }
        StringBuilder StringBuilder2 = new StringBuilder();
        StringBuilder2.append(this.hashCode).append(" (").append(this.syncResult.toString().replace('\n', ' ').trim());
        return StringBuilder2.append(')').toString();
    }

    private static int calculateHash(String path, IntermediateSyncResult<? extends DriveVersion> syncResult) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (path == null ? 0 : path.hashCode());
        result = 31 * result + (syncResult == null ? 0 : syncResult.hashCode());
        return result;
    }
}

