/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal.throttle;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.drive.DirectoryMetadata;
import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveFileField;
import com.openexchange.drive.DriveFileMetadata;
import com.openexchange.drive.DriveQuota;
import com.openexchange.drive.DriveService;
import com.openexchange.drive.DriveSession;
import com.openexchange.drive.DriveSettings;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.SyncResult;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.exception.OXException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ThrottlingDriveService
implements DriveService {
    private final DriveService delegate;
    private final AtomicInteger currentSyncOperations;

    public ThrottlingDriveService(DriveService delegate) throws OXException {
        this.delegate = delegate;
        this.currentSyncOperations = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncResult<DirectoryVersion> syncFolders(DriveSession session, List<DirectoryVersion> originalVersions, List<DirectoryVersion> clientVersions) throws OXException {
        try {
            this.enterSyncOperation();
            SyncResult<DirectoryVersion> syncResult = this.delegate.syncFolders(session, originalVersions, clientVersions);
            return syncResult;
        }
        finally {
            this.leaveSyncOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncResult<FileVersion> syncFiles(DriveSession session, String path, List<FileVersion> originalVersions, List<FileVersion> clientVersions) throws OXException {
        try {
            this.enterSyncOperation();
            SyncResult<FileVersion> syncResult = this.delegate.syncFiles(session, path, originalVersions, clientVersions);
            return syncResult;
        }
        finally {
            this.leaveSyncOperation();
        }
    }

    @Override
    public IFileHolder download(DriveSession session, String path, FileVersion fileVersion, long offset, long length) throws OXException {
        return this.delegate.download(session, path, fileVersion, offset, length);
    }

    @Override
    public SyncResult<FileVersion> upload(DriveSession session, String path, InputStream uploadStream, FileVersion originalVersion, FileVersion newVersion, String contentType, long offset, long totalLength, Date created, Date modified) throws OXException {
        return this.delegate.upload(session, path, uploadStream, originalVersion, newVersion, contentType, offset, totalLength, created, modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriveQuota getQuota(DriveSession session) throws OXException {
        try {
            this.enterSyncOperation();
            DriveQuota driveQuota = this.delegate.getQuota(session);
            return driveQuota;
        }
        finally {
            this.leaveSyncOperation();
        }
    }

    @Override
    public DriveSettings getSettings(DriveSession session) throws OXException {
        return this.delegate.getSettings(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DriveFileMetadata> getFileMetadata(DriveSession session, String path, List<FileVersion> fileVersions, List<DriveFileField> fields) throws OXException {
        try {
            this.enterSyncOperation();
            List<DriveFileMetadata> list = this.delegate.getFileMetadata(session, path, fileVersions, fields);
            return list;
        }
        finally {
            this.leaveSyncOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirectoryMetadata getDirectoryMetadata(DriveSession session, String path) throws OXException {
        try {
            this.enterSyncOperation();
            DirectoryMetadata directoryMetadata = this.delegate.getDirectoryMetadata(session, path);
            return directoryMetadata;
        }
        finally {
            this.leaveSyncOperation();
        }
    }

    private void enterSyncOperation() throws OXException {
        int maxConcurrentSyncOperations = DriveConfig.getInstance().getMaxConcurrentSyncOperations();
        if (0 < maxConcurrentSyncOperations && maxConcurrentSyncOperations < this.currentSyncOperations.incrementAndGet()) {
            throw DriveExceptionCodes.SERVER_BUSY.create();
        }
    }

    public void leaveSyncOperation() {
        this.currentSyncOperations.decrementAndGet();
    }
}

