/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal.throttle;

import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.drive.internal.throttle.TokenBucket;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.exception.OXException;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.session.ServerSession;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriveTokenBucket
implements TokenBucket {
    private static final Logger LOG = LoggerFactory.getLogger(DriveTokenBucket.class);
    private static final int BUCKET_FILLS_PER_SECOND = 4;
    private final ConcurrentMap<String, Semaphore> bucketsPerSession;
    private final Semaphore overallBucket;
    private final int overallBytesPerSecond;
    private final int clientBytesPerSecond;
    private final ScheduledTimerTask bucketFillerTask;

    public DriveTokenBucket() throws OXException {
        this(DriveConfig.getInstance().getMaxBandwidth(), DriveConfig.getInstance().getMaxBandwidthPerClient());
    }

    public DriveTokenBucket(int overallBytesPerSecond, int clientBytesPerSecond) throws OXException {
        this.overallBytesPerSecond = overallBytesPerSecond;
        this.overallBucket = 0 < overallBytesPerSecond ? new Semaphore(overallBytesPerSecond, true) : null;
        this.clientBytesPerSecond = clientBytesPerSecond;
        ConcurrentHashMap concurrentHashMap = this.bucketsPerSession = 0 < clientBytesPerSecond ? new ConcurrentHashMap() : null;
        if (this.isEnabled()) {
            long rate = 250L;
            this.bucketFillerTask = DriveServiceLookup.getService(TimerService.class).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    DriveTokenBucket.this.fillBuckets();
                }
            }, rate, rate);
        } else {
            this.bucketFillerTask = null;
        }
    }

    public void stop() {
        if (null != this.bucketFillerTask) {
            LOG.debug("Cancelling bucket filler task...");
            if (this.bucketFillerTask.cancel()) {
                LOG.info("Bucket filler task cancelled.");
            }
        }
    }

    public boolean isEnabled() {
        return 0 < this.overallBytesPerSecond || 0 < this.clientBytesPerSecond;
    }

    @Override
    public void takeBlocking(ServerSession session, int count) throws InterruptedException {
        if (0 < this.clientBytesPerSecond) {
            DriveTokenBucket.acquire(count, this.getBucket(session), this.clientBytesPerSecond / 4);
        }
        if (0 < this.overallBytesPerSecond) {
            DriveTokenBucket.acquire(count, this.overallBucket, this.overallBytesPerSecond / 4);
        }
    }

    private static void acquire(int count, Semaphore semaphore, int maxPermits) throws InterruptedException {
        int acquired = 0;
        do {
            int permits = Math.min(count - acquired, maxPermits);
            System.out.println("acquire: " + permits + "/" + count);
            semaphore.acquire(permits);
            System.out.println("acquired: " + (acquired += permits) + "/" + count);
        } while (acquired < count);
    }

    @Override
    public boolean tryTake(ServerSession session, int count) {
        if (0 < this.clientBytesPerSecond && !this.getBucket(session).tryAcquire(count)) {
            return false;
        }
        return 0 >= this.overallBytesPerSecond || false != this.overallBucket.tryAcquire(count);
    }

    private void fillBuckets() {
        int maxPermists;
        int permits;
        if (0 < this.overallBytesPerSecond && null != this.overallBucket && 0 < (permits = Math.min(maxPermists = this.overallBytesPerSecond / 4, this.overallBytesPerSecond - this.overallBucket.availablePermits()))) {
            this.overallBucket.release(permits);
            LOG.trace("Released {} permits for 'overall' bucket.", (Object)permits);
        }
        if (0 < this.clientBytesPerSecond && null != this.bucketsPerSession && 0 < this.bucketsPerSession.size()) {
            int maxPermits = this.clientBytesPerSecond / 4;
            Iterator iterator = this.bucketsPerSession.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Semaphore bucket = (Semaphore)entry.getValue();
                int permits2 = Math.min(maxPermits, this.clientBytesPerSecond - bucket.availablePermits());
                if (0 < permits2) {
                    bucket.release(permits2);
                    LOG.trace("Released {} permits for bucket semaphore of session {}", (Object)permits2, entry.getKey());
                    continue;
                }
                iterator.remove();
                LOG.trace("Removed bucket semaphore for session {}", entry.getKey());
            }
        }
    }

    private Semaphore getBucket(ServerSession session) {
        Semaphore newBucket;
        String sessionID = session.getSessionID();
        Semaphore bucket = (Semaphore)this.bucketsPerSession.get(sessionID);
        if (null == bucket && null == (bucket = this.bucketsPerSession.putIfAbsent(sessionID, newBucket = new Semaphore(0, false)))) {
            bucket = newBucket;
            LOG.trace("Created new bucket for {}", (Object)sessionID);
        }
        return bucket;
    }
}

