/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.internal.throttle.BucketInputStream;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class DriveFileHolder
implements IFileHolder {
    private final InputStream stream;
    private final String contentType;
    private final String name;
    private final List<Runnable> tasks;

    public DriveFileHolder(SyncSession session, InputStream stream, String name, String contentType) {
        this(session, stream, name, contentType, true);
    }

    public DriveFileHolder(SyncSession session, InputStream stream, String name, String contentType, boolean throttled) {
        this.contentType = null != contentType ? contentType : "application/octet-stream";
        this.name = name;
        this.stream = throttled ? new BucketInputStream(stream, session.getServerSession()) : stream;
        this.tasks = new LinkedList<Runnable>();
    }

    public List<Runnable> getPostProcessingTasks() {
        return this.tasks;
    }

    public void addPostProcessingTask(Runnable task) {
        if (null != task) {
            this.tasks.add(task);
        }
    }

    public boolean repetitive() {
        return false;
    }

    public void close() throws IOException {
        Streams.close((Closeable)this.stream);
    }

    public InputStream getStream() throws OXException {
        return this.stream;
    }

    public IFileHolder.RandomAccess getRandomAccess() throws OXException {
        return null;
    }

    public long getLength() {
        return -1L;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getDisposition() {
        return null;
    }

    public String getDelivery() {
        return "download";
    }
}

