/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.checksum.ChecksumProvider;
import com.openexchange.drive.internal.DriveFileHolder;
import com.openexchange.drive.internal.PartialInputStream;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.storage.StorageOperation;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import java.io.IOException;
import java.io.InputStream;

public class DownloadHelper {
    private final SyncSession session;

    public DownloadHelper(SyncSession session) {
        this.session = session;
    }

    public IFileHolder perform(final String path, final FileVersion fileVersion, final long offset, final long length) throws OXException {
        return this.session.getStorage().wrapInTransaction(new StorageOperation<IFileHolder>(){

            @Override
            public IFileHolder call() throws OXException {
                File file = DownloadHelper.this.session.getStorage().getFileByName(path, fileVersion.getName(), true);
                if (null == file || !ChecksumProvider.matches(DownloadHelper.this.session, file, fileVersion.getChecksum())) {
                    throw DriveExceptionCodes.FILEVERSION_NOT_FOUND.create(fileVersion.getName(), fileVersion.getChecksum(), path);
                }
                InputStream inputStream = DownloadHelper.this.getInputStream(file, offset, length);
                if (null == inputStream) {
                    throw DriveExceptionCodes.FILE_NOT_FOUND.create(fileVersion.getName(), path);
                }
                return new DriveFileHolder(DownloadHelper.this.session, inputStream, fileVersion.getName(), file.getFileMIMEType());
            }
        });
    }

    private InputStream getInputStream(File file, long offset, long length) throws OXException {
        IDBasedFileAccess fileAccess = this.session.getStorage().getFileAccess();
        InputStream inputStream = null;
        if (0L < offset || 0L < length) {
            if (this.session.getStorage().supports(FileStorageCapability.RANDOM_FILE_ACCESS)) {
                inputStream = fileAccess.getDocument(file.getId(), file.getVersion(), offset, length);
            } else {
                try {
                    inputStream = new PartialInputStream(fileAccess.getDocument(file.getId(), file.getVersion()), offset, length);
                }
                catch (IOException e) {
                    throw DriveExceptionCodes.IO_ERROR.create(e, e.getMessage());
                }
            }
        } else {
            inputStream = fileAccess.getDocument(file.getId(), file.getVersion());
        }
        return inputStream;
    }
}

