/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.comparison;

import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.comparison.Change;
import com.openexchange.drive.comparison.MappingProblems;
import com.openexchange.drive.comparison.ThreeWayComparison;
import com.openexchange.drive.internal.PathNormalizer;
import com.openexchange.java.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class VersionMapper<T extends DriveVersion>
implements Iterable<Map.Entry<String, ThreeWayComparison<T>>> {
    private final Collection<? extends T> originalVersions;
    private final Collection<? extends T> clientVersions;
    private final Collection<? extends T> serverVersions;
    private final SortedMap<String, ThreeWayComparison<T>> map = new TreeMap<String, ThreeWayComparison<T>>(String.CASE_INSENSITIVE_ORDER);
    private final MappingProblems<T> mappingProblems = new MappingProblems();

    public VersionMapper(Collection<? extends T> originalVersions, Collection<? extends T> clientVersions, Collection<? extends T> serverVersions) {
        String existingKey;
        T existingVersion;
        ThreeWayComparison<DriveVersion> comparison;
        String normalizedKey;
        String key;
        if (null == originalVersions) {
            this.originalVersions = Collections.emptyList();
        } else {
            this.originalVersions = originalVersions;
            for (DriveVersion originalVersion : originalVersions) {
                String normalizedKey2 = PathNormalizer.normalize(this.getKey(originalVersion));
                this.getOrCreate(normalizedKey2).setOriginalVersion(originalVersion);
            }
        }
        if (null == clientVersions) {
            this.clientVersions = Collections.emptyList();
        } else {
            this.clientVersions = clientVersions;
            for (DriveVersion clientVersion : clientVersions) {
                key = this.getKey(clientVersion);
                normalizedKey = PathNormalizer.normalize(key);
                comparison = this.getOrCreate(normalizedKey);
                existingVersion = comparison.getClientVersion();
                if (null != existingVersion) {
                    existingKey = this.getKey(existingVersion);
                    comparison.setClientVersion(this.mappingProblems.chooseClientVersion((DriveVersion)existingVersion, existingKey, clientVersion, key));
                    continue;
                }
                comparison.setClientVersion(clientVersion);
            }
        }
        if (null == serverVersions) {
            this.serverVersions = Collections.emptyList();
        } else {
            this.serverVersions = serverVersions;
            for (DriveVersion serverVersion : serverVersions) {
                key = this.getKey(serverVersion);
                normalizedKey = PathNormalizer.normalize(key);
                comparison = this.getOrCreate(normalizedKey);
                existingVersion = comparison.getServerVersion();
                if (null != existingVersion) {
                    existingKey = this.getKey(existingVersion);
                    comparison.setServerVersion(this.mappingProblems.chooseServerVersion((DriveVersion)existingVersion, existingKey, serverVersion, key));
                    continue;
                }
                comparison.setServerVersion(serverVersion);
            }
        }
    }

    @Override
    public Iterator<Map.Entry<String, ThreeWayComparison<T>>> iterator() {
        return this.map.entrySet().iterator();
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public ThreeWayComparison<T> get(String key) {
        return (ThreeWayComparison)this.map.get(key);
    }

    public Collection<? extends T> getOriginalVersions() {
        return this.originalVersions;
    }

    public Collection<? extends T> getClientVersions() {
        return this.clientVersions;
    }

    public Collection<? extends T> getServerVersions() {
        return this.serverVersions;
    }

    public MappingProblems<? extends T> getMappingProblems() {
        return this.mappingProblems;
    }

    protected abstract String getKey(T var1);

    private ThreeWayComparison<T> getOrCreate(String key) {
        ThreeWayComparison comparison = (ThreeWayComparison)this.map.get(key);
        if (null == comparison) {
            comparison = new ThreeWayComparison();
            this.map.put(key, comparison);
        }
        return comparison;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("                                         | Original Version                 | Client Version                     | Server Version                    \n");
        stringBuilder.append("-----------------------------------------+----------------------------------+------------------------------------+-----------------------------------\n");
        for (Map.Entry<String, ThreeWayComparison<T>> entry : this) {
            String name = Strings.abbreviate((String)entry.getKey(), (int)(entry.getKey().length() + 1), (int)40);
            ThreeWayComparison<T> comparison = entry.getValue();
            stringBuilder.append(name);
            for (int i = 0; i < 40 - name.length(); ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(" | ");
            stringBuilder.append(null != comparison.getOriginalVersion() ? comparison.getOriginalVersion().getChecksum() : "                                ");
            stringBuilder.append(" | ");
            stringBuilder.append(null != comparison.getClientVersion() ? comparison.getClientVersion().getChecksum() : "                                ");
            stringBuilder.append(Change.NONE == comparison.getClientChange() ? "  " : ' ' + comparison.getClientChange().toString().substring(0, 1));
            stringBuilder.append(" | ");
            stringBuilder.append(null != comparison.getServerVersion() ? comparison.getServerVersion().getChecksum() : "                                ");
            stringBuilder.append(Change.NONE == comparison.getServerChange() ? "  " : ' ' + comparison.getServerChange().toString().substring(0, 1));
            stringBuilder.append('\n');
            if (100000 >= stringBuilder.length()) continue;
            stringBuilder.append('\n').append("[...]");
            break;
        }
        stringBuilder.append(this.mappingProblems);
        return stringBuilder.toString();
    }
}

