/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.comparison;

import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.checksum.ChecksumProvider;
import com.openexchange.drive.checksum.DirectoryChecksum;
import com.openexchange.drive.internal.PathNormalizer;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.exception.OXException;
import java.util.Arrays;
import java.util.List;

public class ServerDirectoryVersion
implements DirectoryVersion {
    private final String path;
    private final String normalizedPath;
    private final DirectoryChecksum checksum;

    public ServerDirectoryVersion(String path, DirectoryChecksum checksum) {
        this.path = path;
        this.normalizedPath = PathNormalizer.normalize(path);
        this.checksum = checksum;
    }

    @Override
    public String getChecksum() {
        return this.checksum.getChecksum();
    }

    @Override
    public String getPath() {
        return this.normalizedPath;
    }

    public DirectoryChecksum getDirectoryChecksum() {
        return this.checksum;
    }

    public static ServerDirectoryVersion valueOf(DirectoryVersion directoryVersion, SyncSession session) throws OXException {
        if (ServerDirectoryVersion.class.isInstance(directoryVersion)) {
            return (ServerDirectoryVersion)directoryVersion;
        }
        String folderID = session.getStorage().getFolderID(directoryVersion.getPath());
        List<DirectoryChecksum> checksums = ChecksumProvider.getChecksums(session, Arrays.asList(folderID));
        if (null == checksums || 0 == checksums.size() || !directoryVersion.getChecksum().equals(checksums.get(0).getChecksum())) {
            throw DriveExceptionCodes.DIRECTORYVERSION_NOT_FOUND.create(directoryVersion.getPath(), directoryVersion.getChecksum());
        }
        return new ServerDirectoryVersion(directoryVersion.getPath(), checksums.get(0));
    }

    public String toString() {
        return this.getPath() + " | " + this.getChecksum() + " [" + this.getDirectoryChecksum().getFolderID() + ']';
    }
}

