/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.comparison;

import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.internal.PathNormalizer;
import java.util.ArrayList;
import java.util.List;

public class MappingProblems<T extends DriveVersion> {
    private List<T> caseConflictingClientVersions;
    private List<T> unicodeConflictingClientVersions;
    private List<T> caseConflictingServerVersions;
    private List<T> unicodeConflictingServerVersions;

    public List<T> getCaseConflictingClientVersions() {
        return this.caseConflictingClientVersions;
    }

    public List<T> getUnicodeConflictingClientVersions() {
        return this.unicodeConflictingClientVersions;
    }

    public List<T> getCaseConflictingServerVersions() {
        return this.caseConflictingServerVersions;
    }

    public List<T> getUnicodeConflictingServerVersions() {
        return this.unicodeConflictingServerVersions;
    }

    public T chooseServerVersion(T version1, String key1, T version2, String key2) {
        boolean key1Normalized = PathNormalizer.isNormalized(key1);
        boolean key2Normalized = PathNormalizer.isNormalized(key2);
        if (key1Normalized && key2Normalized) {
            if (null == this.caseConflictingServerVersions) {
                this.caseConflictingServerVersions = new ArrayList<T>();
            }
            this.caseConflictingServerVersions.add(version2);
            return version1;
        }
        if (null == this.unicodeConflictingServerVersions) {
            this.unicodeConflictingServerVersions = new ArrayList<T>();
        }
        if (key2Normalized) {
            this.unicodeConflictingServerVersions.add(version1);
            return version2;
        }
        this.unicodeConflictingServerVersions.add(version2);
        return version1;
    }

    public T chooseClientVersion(T version1, String key1, T version2, String key2) {
        boolean key1Normalized = PathNormalizer.isNormalized(key1);
        boolean key2Normalized = PathNormalizer.isNormalized(key2);
        if (key1Normalized && key2Normalized) {
            if (null == this.caseConflictingClientVersions) {
                this.caseConflictingClientVersions = new ArrayList<T>();
            }
            this.caseConflictingClientVersions.add(version2);
            return version1;
        }
        if (null == this.unicodeConflictingClientVersions) {
            this.unicodeConflictingClientVersions = new ArrayList<T>();
        }
        if (key2Normalized) {
            this.unicodeConflictingClientVersions.add(version1);
            return version2;
        }
        this.unicodeConflictingClientVersions.add(version2);
        return version1;
    }

    public String toString() {
        StringBuilder StringBuilder2 = new StringBuilder();
        this.appendVersions(StringBuilder2, this.caseConflictingClientVersions, "Case conflicting client versions");
        this.appendVersions(StringBuilder2, this.unicodeConflictingClientVersions, "Unicode conflicting client versions");
        this.appendVersions(StringBuilder2, this.caseConflictingServerVersions, "Case conflicting server versions");
        this.appendVersions(StringBuilder2, this.unicodeConflictingServerVersions, "Unicode conflicting server versions");
        return StringBuilder2.toString();
    }

    private void appendVersions(StringBuilder StringBuilder2, List<T> versions, String header) {
        if (null != versions && 0 < versions.size()) {
            StringBuilder2.append('\n').append(header).append(":\n");
            for (DriveVersion version : versions) {
                StringBuilder2.append("  ").append(version).append('\n');
            }
        }
    }
}

