/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.comparison;

import com.openexchange.drive.DirectoryPattern;
import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.comparison.DirectoryVersionMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilteringDirectoryVersionMapper
extends DirectoryVersionMapper {
    public FilteringDirectoryVersionMapper(List<DirectoryPattern> directoryExclusions, Collection<? extends DirectoryVersion> originalVersions, Collection<? extends DirectoryVersion> clientVersions, Collection<? extends DirectoryVersion> serverVersions) {
        super(FilteringDirectoryVersionMapper.filterExclusions(originalVersions, directoryExclusions), clientVersions, FilteringDirectoryVersionMapper.filterExclusions(serverVersions, directoryExclusions));
    }

    @Override
    protected String getKey(DirectoryVersion version) {
        return version.getPath();
    }

    private static Collection<? extends DirectoryVersion> filterExclusions(Collection<? extends DirectoryVersion> directoryVersions, List<DirectoryPattern> directoryExclusions) {
        if (null == directoryExclusions || 0 == directoryExclusions.size()) {
            return directoryVersions;
        }
        ArrayList<DirectoryVersion> filteredVersions = new ArrayList<DirectoryVersion>(directoryVersions.size());
        for (DirectoryVersion directoryVersion : directoryVersions) {
            if (FilteringDirectoryVersionMapper.matchesAny(directoryVersion, directoryExclusions)) continue;
            filteredVersions.add(directoryVersion);
        }
        return filteredVersions;
    }

    private static boolean matchesAny(DirectoryVersion directoryVersion, List<DirectoryPattern> patterns) {
        String path = directoryVersion.getPath();
        for (DirectoryPattern directoryExclusion : patterns) {
            if (!directoryExclusion.matches(path)) continue;
            return true;
        }
        return false;
    }
}

