/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum.rdb;

import com.openexchange.drive.checksum.rdb.SQL;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteFailedExceptionCodes;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class DriveDeleteListener
implements DeleteListener {
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (5 == event.getType()) {
            try {
                DriveDeleteListener.deleteFileChecksums(writeCon, event.getContext().getContextId());
                DriveDeleteListener.deleteDirectoryChecksums(writeCon, event.getContext().getContextId());
            }
            catch (SQLException e) {
                throw DeleteFailedExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Exception e) {
                throw DeleteFailedExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteFileChecksums(Connection connection, int cid) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("DELETE FROM fileChecksums WHERE cid=?;");
            stmt.setInt(1, cid);
            int n = SQL.logExecuteUpdate(stmt);
            return n;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteDirectoryChecksums(Connection connection, int cid) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("DELETE FROM directoryChecksums WHERE cid=?;");
            stmt.setInt(1, cid);
            int n = SQL.logExecuteUpdate(stmt);
            return n;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }
}

