/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum.rdb;

import com.openexchange.database.DatabaseService;
import com.openexchange.drive.checksum.rdb.DriveCreateTableTask;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class DirectoryChecksumsAddUserAndETagColumnTask
extends UpdateTaskAdapter {
    public String[] getDependencies() {
        return new String[]{DriveCreateTableTask.class.getName()};
    }

    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService dbService = DriveServiceLookup.getService(DatabaseService.class);
        Connection connection = dbService.getForUpdateTask(contextID);
        boolean committed = false;
        try {
            connection.setAutoCommit(false);
            if (!Tools.columnExists((Connection)connection, (String)"directoryChecksums", (String)"user")) {
                DirectoryChecksumsAddUserAndETagColumnTask.deleteDirectoryChecksums(connection);
            }
            if (!Tools.isNullable((Connection)connection, (String)"directoryChecksums", (String)"sequence")) {
                Tools.modifyColumns((Connection)connection, (String)"directoryChecksums", (Column[])new Column[]{new Column("sequence", "BIGINT(20) DEFAULT NULL")});
            }
            Tools.checkAndAddColumns((Connection)connection, (String)"directoryChecksums", (Column[])new Column[]{new Column("user", "INT4 UNSIGNED DEFAULT NULL"), new Column("etag", "VARCHAR(255) DEFAULT NULL")});
            connection.commit();
            committed = true;
        }
        catch (SQLException e) {
            DBUtils.rollback((Connection)connection);
            throw UpdateExceptionCodes.SQL_PROBLEM.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (RuntimeException e) {
            DBUtils.rollback((Connection)connection);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            DBUtils.autocommit((Connection)connection);
            if (committed) {
                dbService.backForUpdateTask(contextID, connection);
            } else {
                dbService.backForUpdateTaskAfterReading(contextID, connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteDirectoryChecksums(Connection connection) throws SQLException {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.execute("DELETE FROM directoryChecksums;");
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }
}

