/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum.events;

import com.openexchange.drive.DriveClientType;
import com.openexchange.drive.checksum.rdb.RdbChecksumStore;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageEventHelper;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.session.Session;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumEventListener
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChecksumEventListener.class);

    public static String[] getHandledTopics() {
        return new String[]{"com/openexchange/groupware/infostore/delete", "com/openexchange/groupware/infostore/update", "com/openexchange/groupware/infostore/insert", "com/openexchange/groupware/fsfolder/delete", "com/openexchange/groupware/fsfolder/update"};
    }

    public void handleEvent(final Event event) {
        try {
            Session session = FileStorageEventHelper.extractSession((Event)event);
            if (null == session || ChecksumEventListener.isDriveSession(session)) {
                return;
            }
            LOG.debug("{}", new Object(){

                public String toString() {
                    return FileStorageEventHelper.createDebugMessage((String)"event", (Event)event);
                }
            });
            RdbChecksumStore checksumStore = new RdbChecksumStore(session.getContextId());
            String topic = event.getTopic();
            if ("com/openexchange/groupware/infostore/delete".equals(topic) || "com/openexchange/groupware/infostore/update".equals(topic) || "com/openexchange/groupware/infostore/insert".equals(topic)) {
                String serviceID = FileStorageEventHelper.extractService((Event)event);
                String accountID = FileStorageEventHelper.extractAccountId((Event)event);
                String folderID = FileStorageEventHelper.extractFolderId((Event)event);
                checksumStore.removeDirectoryChecksum(new FolderID(serviceID, accountID, folderID));
                if ("com/openexchange/groupware/infostore/delete".equals(topic) || "com/openexchange/groupware/infostore/update".equals(topic)) {
                    String objectID = FileStorageEventHelper.extractObjectId((Event)event);
                    checksumStore.removeFileChecksums(new FileID(serviceID, accountID, folderID, objectID));
                }
            } else if ("com/openexchange/groupware/fsfolder/delete".equals(topic) || "com/openexchange/groupware/fsfolder/update".equals(topic)) {
                String serviceID = FileStorageEventHelper.extractService((Event)event);
                String accountID = FileStorageEventHelper.extractAccountId((Event)event);
                String folderID = FileStorageEventHelper.extractFolderId((Event)event);
                FolderID id = new FolderID(serviceID, accountID, folderID);
                checksumStore.removeDirectoryChecksum(id);
                checksumStore.removeFileChecksumsInFolder(id);
            }
        }
        catch (OXException e) {
            LOG.warn("unexpected error during event handling", (Throwable)e);
        }
    }

    private static boolean isDriveSession(Session session) {
        return null != session && false == DriveClientType.UNKNOWN.equals((Object)DriveClientType.parse(session.getClient()));
    }
}

