/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum;

import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.checksum.DirectoryChecksum;
import com.openexchange.drive.checksum.FileChecksum;
import com.openexchange.drive.internal.PathNormalizer;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import jonelo.jacksum.algorithm.MD;

public class ChecksumProvider {
    private static final Comparator<File> FILENAME_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            byte[] fileName1 = PathNormalizer.normalize(o1.getFileName()).getBytes(Charsets.UTF_8);
            byte[] fileName2 = PathNormalizer.normalize(o2.getFileName()).getBytes(Charsets.UTF_8);
            int minLength = Math.min(fileName1.length, fileName2.length);
            for (int i = 0; i < minLength; ++i) {
                int result = (fileName1[i] & 0xFF) - (fileName2[i] & 0xFF);
                if (result == 0) continue;
                return result;
            }
            return fileName1.length - fileName2.length;
        }
    };

    public static FileChecksum getChecksum(SyncSession session, File file) throws OXException {
        FileChecksum fileChecksum = session.getChecksumStore().getFileChecksum(DriveUtils.getFileID(file), file.getVersion(), file.getSequenceNumber());
        if (null == fileChecksum) {
            fileChecksum = session.getChecksumStore().insertFileChecksum(ChecksumProvider.calculateFileChecksum(session, file));
        }
        return fileChecksum;
    }

    public static List<FileChecksum> getChecksums(SyncSession session, String folderID, List<File> files) throws OXException {
        ArrayList<FileChecksum> checksums = new ArrayList<FileChecksum>(files.size());
        List<FileChecksum> storedChecksums = session.getChecksumStore().getFileChecksums(new FolderID(folderID));
        ArrayList<FileChecksum> newChecksums = new ArrayList<FileChecksum>();
        for (File file : files) {
            if (!folderID.equals(file.getFolderId())) {
                throw new IllegalArgumentException("files must all have the same folder ID");
            }
            FileChecksum fileChecksum = ChecksumProvider.find(storedChecksums, file);
            if (null == fileChecksum) {
                fileChecksum = ChecksumProvider.calculateFileChecksum(session, file);
                newChecksums.add(fileChecksum);
            }
            checksums.add(fileChecksum);
        }
        if (0 < newChecksums.size()) {
            session.getChecksumStore().insertFileChecksums(newChecksums);
        }
        return checksums;
    }

    public static List<DirectoryChecksum> getChecksums(SyncSession session, List<String> folderIDs) throws OXException {
        List<DirectoryChecksum> checksums;
        StringBuilder trace = session.isTraceEnabled() ? new StringBuilder("Directory checksums:\n") : null;
        ArrayList<FolderID> fids = new ArrayList<FolderID>(folderIDs.size());
        for (String folderID : folderIDs) {
            fids.add(new FolderID(folderID));
        }
        int userID = session.getServerSession().getUserId();
        if (!session.getStorage().supports(FileStorageCapability.SEQUENCE_NUMBERS)) {
            if (null != trace) {
                trace.append(" No folder sequence numbers supported.\n");
            }
            checksums = ChecksumProvider.calculateDirectoryChecksums(session, fids);
        } else {
            int view = session.getExclusionFilterHash();
            checksums = new ArrayList<DirectoryChecksum>(folderIDs.size());
            List<DirectoryChecksum> storedChecksums = session.getChecksumStore().getDirectoryChecksums(userID, fids, view);
            ArrayList<DirectoryChecksum> updatedChecksums = new ArrayList<DirectoryChecksum>();
            ArrayList<DirectoryChecksum> newChecksums = new ArrayList<DirectoryChecksum>();
            Map<String, Long> sequenceNumbers = session.getStorage().getSequenceNumbers(folderIDs);
            for (FolderID folderID : fids) {
                long sequenceNumber;
                DirectoryChecksum directoryChecksum = ChecksumProvider.find(storedChecksums, folderID, view);
                Long value = sequenceNumbers.get(folderID.toUniqueID());
                long l = sequenceNumber = null != value ? value : 0L;
                if (null != directoryChecksum) {
                    if (sequenceNumber != directoryChecksum.getSequenceNumber()) {
                        if (null != trace) {
                            trace.append(" Stored, invalid ( != " + sequenceNumber + " ): ").append(directoryChecksum).append('\n');
                        }
                        directoryChecksum.setChecksum(ChecksumProvider.calculateMD5(session, folderID));
                        directoryChecksum.setSequenceNumber(sequenceNumber);
                        updatedChecksums.add(directoryChecksum);
                        if (null != trace) {
                            trace.append(" Re-calculated: ").append(directoryChecksum).append('\n');
                        }
                    } else if (null != trace) {
                        trace.append(" Stored, valid: ").append(directoryChecksum).append('\n');
                    }
                } else {
                    directoryChecksum = new DirectoryChecksum(userID, folderID, sequenceNumber, ChecksumProvider.calculateMD5(session, folderID), view);
                    if (null != trace) {
                        trace.append(" Newly calculated: ").append(directoryChecksum).append('\n');
                    }
                    newChecksums.add(directoryChecksum);
                }
                checksums.add(directoryChecksum);
            }
            if (0 < updatedChecksums.size()) {
                session.getChecksumStore().updateDirectoryChecksums(updatedChecksums);
            }
            if (0 < newChecksums.size()) {
                session.getChecksumStore().insertDirectoryChecksums(newChecksums);
            }
        }
        if (null != trace) {
            session.trace(trace);
        }
        return checksums;
    }

    public static boolean matches(SyncSession session, File file, String checksum) throws OXException {
        return checksum.equals(ChecksumProvider.getChecksum(session, file).getChecksum());
    }

    private static List<DirectoryChecksum> calculateDirectoryChecksums(SyncSession session, List<FolderID> folderIDs) throws OXException {
        int view = session.getExclusionFilterHash();
        ArrayList<DirectoryChecksum> checksums = new ArrayList<DirectoryChecksum>(folderIDs.size());
        for (FolderID folderID : folderIDs) {
            checksums.add(new DirectoryChecksum(session.getServerSession().getUserId(), folderID, -1L, ChecksumProvider.calculateMD5(session, folderID), view));
        }
        return checksums;
    }

    private static String calculateMD5(SyncSession session, FolderID folderID) throws OXException {
        String checksum;
        StringBuilder trace = session.isTraceEnabled() ? new StringBuilder("File checksums in folder " + folderID + ":\n") : null;
        List<File> filesInFolder = session.getStorage().getFilesInFolder(folderID.toUniqueID());
        if (null == filesInFolder || 0 == filesInFolder.size()) {
            checksum = "d41d8cd98f00b204e9800998ecf8427e";
            if (null != trace) {
                trace.append(" no files in folder, using empty MD5\n");
            }
        } else {
            TreeSet<File> files = new TreeSet<File>(FILENAME_COMPARATOR);
            files.addAll(filesInFolder);
            MD md5 = session.newMD5();
            List<FileChecksum> knownChecksums = session.getChecksumStore().getFileChecksums(folderID);
            ArrayList<FileChecksum> calculatedChecksums = new ArrayList<FileChecksum>();
            for (File file : files) {
                FileChecksum fileChecksum = ChecksumProvider.find(knownChecksums, file);
                if (null == fileChecksum) {
                    fileChecksum = ChecksumProvider.calculateFileChecksum(session, file);
                    if (null != trace) {
                        trace.append(' ' + file.getFileName()).append(" - Newly calculated: ").append(fileChecksum).append('\n');
                    }
                    calculatedChecksums.add(fileChecksum);
                } else if (null != trace) {
                    trace.append(' ' + file.getFileName()).append(" - Stored, valid: ").append(fileChecksum).append('\n');
                }
                md5.update(PathNormalizer.normalize(file.getFileName()).getBytes(Charsets.UTF_8));
                md5.update(fileChecksum.getChecksum().getBytes(Charsets.UTF_8));
            }
            if (0 < calculatedChecksums.size()) {
                session.getChecksumStore().insertFileChecksums(calculatedChecksums);
            }
            checksum = md5.getFormattedValue();
        }
        if (null != trace) {
            trace.append("Directory checksum: ").append(checksum).append('\n');
            session.trace(trace);
        }
        return checksum;
    }

    private static FileChecksum calculateFileChecksum(SyncSession session, File file) throws OXException {
        String md5;
        String string = md5 = Strings.isEmpty((String)file.getFileMD5Sum()) ? ChecksumProvider.calculateMD5(session, file) : file.getFileMD5Sum();
        if (null == md5) {
            throw DriveExceptionCodes.NO_CHECKSUM_FOR_FILE.create(file);
        }
        FileChecksum fileChecksum = new FileChecksum();
        fileChecksum.setFileID(DriveUtils.getFileID(file));
        fileChecksum.setSequenceNumber(file.getSequenceNumber());
        fileChecksum.setVersion(file.getVersion());
        fileChecksum.setChecksum(md5);
        return fileChecksum;
    }

    private static String calculateMD5(SyncSession session, File file) throws OXException {
        String string;
        InputStream document = null;
        try {
            document = session.getStorage().getDocument(file);
            string = ChecksumProvider.calculateMD5(document);
        }
        catch (IOException e) {
            try {
                throw DriveExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Streams.close(document);
                throw throwable;
            }
        }
        Streams.close((Closeable)document);
        return string;
    }

    private static String calculateMD5(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[2048];
        try {
            int read;
            MD md5 = new MD("MD5");
            do {
                if (0 >= (read = inputStream.read(buffer))) continue;
                md5.update(buffer, 0, read);
            } while (-1 != read);
            return md5.getFormattedValue();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private static FileChecksum find(Collection<? extends FileChecksum> checksums, File file) {
        for (FileChecksum fileChecksum : checksums) {
            String fileID = fileChecksum.getFileID().toUniqueID();
            String folderID = new FolderID(fileChecksum.getFileID().getService(), fileChecksum.getFileID().getAccountId(), fileChecksum.getFileID().getFolderId()).toUniqueID();
            if (!fileID.equals(file.getId()) || !folderID.equals(file.getFolderId()) || !(null == fileChecksum.getVersion() ? null == file.getVersion() : fileChecksum.getVersion().equals(file.getVersion())) || fileChecksum.getSequenceNumber() != file.getSequenceNumber()) continue;
            return fileChecksum;
        }
        return null;
    }

    private static DirectoryChecksum find(Collection<? extends DirectoryChecksum> checksums, FolderID folderID, int view) {
        for (DirectoryChecksum directoryChecksum : checksums) {
            if (!directoryChecksum.getFolderID().equals((Object)folderID) || directoryChecksum.getView() != view) continue;
            return directoryChecksum;
        }
        return null;
    }
}

