/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.actions;

import com.openexchange.drive.FileVersion;
import com.openexchange.drive.actions.AbstractFileAction;
import com.openexchange.drive.comparison.ServerFileVersion;
import com.openexchange.drive.comparison.ThreeWayComparison;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.file.storage.File;
import java.util.HashMap;
import java.util.Map;

public abstract class DynamicMetadataFileAction
extends AbstractFileAction {
    protected final SyncSession session;
    private File metadata;
    private AbstractFileAction dependingAction;

    public DynamicMetadataFileAction(SyncSession session, FileVersion file, ServerFileVersion newFile, ThreeWayComparison<FileVersion> comparison, String path) {
        this(session, file, newFile, comparison, path, null != newFile ? newFile.getFile() : null);
    }

    public DynamicMetadataFileAction(SyncSession session, FileVersion file, FileVersion newFile, ThreeWayComparison<FileVersion> comparison, String path, File serverFile) {
        super(file, newFile, comparison);
        this.parameters.put("path", path);
        this.session = session;
        this.metadata = serverFile;
    }

    @Override
    public Map<String, Object> getParameters() {
        FileVersion fileVersion;
        Map<String, Object> parameters = super.getParameters();
        if (null != this.dependingAction && null != (fileVersion = (FileVersion)this.dependingAction.getResultingVersion()) && ServerFileVersion.class.isInstance(fileVersion)) {
            this.metadata = ((ServerFileVersion)fileVersion).getFile();
        }
        if (null != this.metadata) {
            parameters = new HashMap<String, Object>(parameters);
            this.applyMetadataParameters(this.metadata, this.session);
        }
        return parameters;
    }

    public void setDependingAction(AbstractFileAction action) {
        this.dependingAction = action;
    }
}

