/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.actions;

import com.openexchange.drive.Action;
import com.openexchange.drive.DriveAction;
import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.comparison.Change;
import com.openexchange.drive.comparison.ThreeWayComparison;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractAction<T extends DriveVersion>
implements DriveAction<T> {
    protected final T version;
    protected final T newVersion;
    protected final Map<String, Object> parameters;
    protected ThreeWayComparison<T> comparison;
    protected T resultingVersion;

    protected AbstractAction(T version, T newVersion, ThreeWayComparison<T> comparison) {
        this.comparison = comparison;
        this.version = version;
        this.newVersion = newVersion;
        this.parameters = new HashMap<String, Object>();
    }

    @Override
    public T getVersion() {
        return this.version;
    }

    @Override
    public T getNewVersion() {
        return this.newVersion;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public int compareTo(DriveAction<T> other) {
        Action otherAction;
        Action thisAction = this.getAction();
        Action action = otherAction = null != other ? other.getAction() : null;
        if (null == otherAction) {
            return null == thisAction ? 0 : -1;
        }
        return thisAction.compareTo(otherAction);
    }

    public String toString() {
        return (Object)((Object)this.getAction()) + " [version=" + this.version + ", newVersion=" + this.newVersion + ", parameters=" + this.parameters + "]";
    }

    public boolean wasCausedBy(Change clientChange, Change serverChange) {
        if (null == this.comparison) {
            throw new UnsupportedOperationException("no comparison available");
        }
        return this.comparison.getClientChange().equals((Object)clientChange) && this.comparison.getServerChange().equals((Object)serverChange);
    }

    public ThreeWayComparison<T> getComparison() {
        return this.comparison;
    }

    public T getResultingVersion() {
        return this.resultingVersion;
    }

    public void setResultingVersion(T version) {
        this.resultingVersion = version;
    }
}

