/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive;

import com.openexchange.drive.DirectoryPattern;
import com.openexchange.drive.DriveConstants;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveSession;
import com.openexchange.drive.FilePattern;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.actions.DownloadFileAction;
import com.openexchange.drive.actions.EditFileAction;
import com.openexchange.drive.actions.ErrorFileAction;
import com.openexchange.drive.comparison.ServerFileVersion;
import com.openexchange.drive.internal.PathNormalizer;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.drive.storage.DriveStorage;
import com.openexchange.drive.sync.RenameTools;
import com.openexchange.drive.sync.SimpleFileVersion;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.java.Strings;
import com.openexchange.quota.QuotaExceptionCodes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DriveUtils {
    public static FileID getFileID(File file) {
        if (null == file.getId() || null == file.getFolderId()) {
            throw new IllegalArgumentException("File- and folder IDs  are required");
        }
        FileID fileID = new FileID(file.getId());
        FolderID folderID = new FolderID(file.getFolderId());
        if (null == fileID.getFolderId()) {
            fileID.setFolderId(folderID.getFolderId());
        }
        return fileID;
    }

    public static boolean isInvalidPath(String path) throws OXException {
        if (Strings.isEmpty((String)path)) {
            return true;
        }
        if (!DriveConstants.PATH_VALIDATION_PATTERN.matcher(path).matches()) {
            return true;
        }
        for (String pathSegment : DriveStorage.split(path)) {
            if (255 >= pathSegment.length()) continue;
            return true;
        }
        return false;
    }

    public static boolean isIgnoredPath(SyncSession session, String path) throws OXException {
        if ("/.drive".equalsIgnoreCase(path)) {
            return true;
        }
        if (DriveConfig.getInstance().getExcludedDirectoriesPattern().matcher(path).matches()) {
            return true;
        }
        List<DirectoryPattern> directoryExclusions = session.getDriveSession().getDirectoryExclusions();
        if (null != directoryExclusions && 0 < directoryExclusions.size()) {
            for (DirectoryPattern pattern : directoryExclusions) {
                if (!pattern.matches(path)) continue;
                return true;
            }
        }
        if (session.getStorage().hasTrashFolder()) {
            FileStorageFolder trashFolder = session.getStorage().getTrashFolder();
            String trashPath = session.getStorage().getPath(trashFolder.getId());
            if (null != trashPath && trashPath.equals(path)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInvalidFileName(String fileName) {
        if (Strings.isEmpty((String)fileName)) {
            return true;
        }
        if (!DriveConstants.FILENAME_VALIDATION_PATTERN.matcher(fileName).matches()) {
            return true;
        }
        return 255 < fileName.length();
    }

    public static boolean isIgnoredFileName(String fileName) {
        if (fileName.endsWith(".drivepart")) {
            return true;
        }
        return DriveConfig.getInstance().getExcludedFilenamesPattern().matcher(fileName).matches();
    }

    public static boolean isIgnoredFileName(DriveSession session, String path, String fileName) throws OXException {
        if (DriveUtils.isIgnoredFileName(fileName)) {
            return true;
        }
        List<FilePattern> fileExclusions = session.getFileExclusions();
        if (null != fileExclusions && 0 < fileExclusions.size()) {
            for (FilePattern pattern : fileExclusions) {
                if (!pattern.matches(path, fileName)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<AbstractAction<FileVersion>> handleQuotaExceeded(SyncSession session, OXException quotaException, String path, FileVersion originalVersion, FileVersion newVersion) throws OXException {
        ArrayList<AbstractAction<FileVersion>> actionsForClient = new ArrayList<AbstractAction<FileVersion>>();
        OXException quotaReachedException = DriveExceptionCodes.QUOTA_REACHED.create((Throwable)quotaException, (Object[])null);
        if (null != originalVersion) {
            String alternativeName = RenameTools.findRandomAlternativeName(originalVersion.getName());
            SimpleFileVersion renamedVersion = new SimpleFileVersion(alternativeName, originalVersion.getChecksum());
            actionsForClient.add(new EditFileAction(newVersion, (FileVersion)renamedVersion, null, path, false));
            actionsForClient.add(new ErrorFileAction(newVersion, renamedVersion, null, path, quotaReachedException, true));
            ServerFileVersion serverFileVersion = ServerFileVersion.valueOf(originalVersion, path, session);
            actionsForClient.add(new DownloadFileAction(session, null, serverFileVersion, null, path));
        } else {
            actionsForClient.add(new ErrorFileAction(null, newVersion, null, path, quotaReachedException, true));
        }
        return actionsForClient;
    }

    public static boolean indicatesQuotaExceeded(OXException e) {
        return "FLS-0024".equals(e.getErrorCode()) || FileStorageExceptionCodes.QUOTA_REACHED.equals(e) || DriveExceptionCodes.QUOTA_REACHED.equals(e) || "SMARTDRIVEFILE_STORAGE-0008".equals(e.getErrorCode()) || QuotaExceptionCodes.QUOTA_EXCEEDED.equals(e) || QuotaExceptionCodes.QUOTA_EXCEEDED_FILES.equals(e);
    }

    public static boolean indicatesFailedSave(OXException e) {
        return "IFO-0100".equals(e.getErrorCode()) || "IFO-2103".equals(e.getErrorCode()) || "FLD-0092".equals(e.getErrorCode()) || "FLD-0064".equals(e.getErrorCode());
    }

    public static Set<String> getNormalizedFolderNames(Collection<FileStorageFolder> folders) {
        if (null == folders || 0 == folders.size()) {
            return Collections.emptySet();
        }
        HashSet<String> folderNames = new HashSet<String>(folders.size());
        for (FileStorageFolder folder : folders) {
            folderNames.add(PathNormalizer.normalize(folder.getName()));
        }
        return folderNames;
    }

    public static Set<String> getNormalizedFileNames(Collection<File> files, boolean lowercase) {
        if (null == files || 0 == files.size()) {
            return Collections.emptySet();
        }
        HashSet<String> fileNames = new HashSet<String>(files.size());
        for (File file : files) {
            String normalizedName = PathNormalizer.normalize(file.getFileName());
            if (lowercase) {
                normalizedName = normalizedName.toLowerCase();
            }
            fileNames.add(normalizedName);
        }
        return fileNames;
    }

    private DriveUtils() {
    }
}

