/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.task;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.FolderTest;
import com.openexchange.webdav.xml.GroupUserTest;
import com.openexchange.webdav.xml.TaskTest;
import java.util.Date;
import java.util.Locale;

public class NewTest
extends TaskTest {
    public NewTest(String name) {
        super(name);
    }

    public void testNewTask() throws Exception {
        Task taskObj = this.createTask("testNewTask");
        NewTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testNewTaskWithParticipants() throws Exception {
        Task taskObj = this.createTask("testNewTaskWithParticipants");
        int userParticipantId2 = GroupUserTest.getUserId(this.getWebConversation(), "http://" + this.getHostName(), this.userParticipant2, this.getPassword(), this.context);
        NewTest.assertTrue((String)"user participant not found", (userParticipantId2 != -1 ? 1 : 0) != 0);
        int userParticipantId3 = GroupUserTest.getUserId(this.getWebConversation(), "http://" + this.getHostName(), this.userParticipant3, this.getPassword(), this.context);
        NewTest.assertTrue((String)"user participant not found", (userParticipantId3 != -1 ? 1 : 0) != 0);
        Participant[] participants = new Participant[]{new UserParticipant()};
        participants[0].setIdentifier(userParticipantId2);
        participants[0] = new UserParticipant();
        participants[0].setIdentifier(userParticipantId3);
        taskObj.setParticipants(participants);
        NewTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testNewTaskWithAlarm() throws Exception {
        Task taskObj = this.createTask("testNewTaskWithAlarm");
        taskObj.setAlarm(new Date(this.startTime.getTime() - 172800000L));
        int objectId = NewTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        taskObj.setObjectID(objectId);
        Task loadTask = NewTest.loadTask(this.getWebConversation(), objectId, this.taskFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(taskObj, loadTask);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.taskFolderId}};
        NewTest.deleteTask(this.getWebConversation(), objectIdAndFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testNewTaskWithUsers() throws Exception {
        Task taskObj = this.createTask("testNewTaskWithUsers");
        int userParticipantId = GroupUserTest.getUserId(this.getWebConversation(), "http://" + this.getHostName(), this.userParticipant2, this.getPassword(), this.context);
        NewTest.assertTrue((String)"user participant not found", (userParticipantId != -1 ? 1 : 0) != 0);
        UserParticipant[] users = new UserParticipant[]{new UserParticipant()};
        users[0].setIdentifier(userParticipantId);
        users[0].setConfirm(1);
        taskObj.setUsers(users);
        NewTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testTaskWithPrivateFlagInPublicFolder() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testTaskWithPrivateFlagInPublicFolder" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Task taskObj = new Task();
        taskObj.setTitle("testTaskWithPrivateFlagInPublicFolder");
        taskObj.setPrivateFlag(true);
        taskObj.setParentFolderID(parentFolderId);
        try {
            int objectId = NewTest.insertTask(this.getWebConversation(), taskObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
            NewTest.deleteTask(this.getWebConversation(), objectId, parentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
            NewTest.fail((String)"conflict exception expected!");
        }
        catch (OXException exc) {
            NewTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), "TSK-0008");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkAdd() throws Exception {
        int i;
        int[] objectIds = null;
        int NUMBER_OF_TASKS = 30;
        Task[] tasks = new Task[30];
        for (i = 0; i < 30; ++i) {
            tasks[i] = this.createTask("TASK - " + i);
        }
        try {
            objectIds = NewTest.insertTasks(this.webCon, "http://" + this.hostName, this.login, this.password, this.context, tasks);
            i = 0;
            for (int objectId : objectIds) {
                Task task = NewTest.loadTask(this.getWebConversation(), objectId, tasks[i].getParentFolderID(), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
                tasks[i].setObjectID(objectId);
                NewTest.compareObject(task, tasks[i]);
                ++i;
            }
        }
        finally {
            if (null != objectIds) {
                i = 0;
                try {
                    for (int objectId : objectIds) {
                        NewTest.deleteTask(this.getWebConversation(), objectId, tasks[i].getParentFolderID(), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
                        ++i;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }
}

