/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.java.Charsets;
import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavPutAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;

public class PutTest
extends ActionTestCase {
    private WebdavPath INDEX_HTML_URL = null;
    private WebdavPath INDEX23_HTML_URL = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
        this.INDEX23_HTML_URL = this.testCollection.dup().append(new String[]{"index23.html"});
    }

    public void testBasic() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        String content = "<html><head /><body>The New, Better Index</body></html>";
        req.setBodyAsString("<html><head /><body>The New, Better Index</body></html>");
        req.setHeader("content-length", Integer.valueOf("<html><head /><body>The New, Better Index</body></html>".getBytes(Charsets.UTF_8).length).toString());
        req.setHeader("content-type", "text/html");
        WebdavPutAction action = new WebdavPutAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PutTest.assertEquals((int)201, (int)res.getStatus());
        WebdavResource resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        PutTest.assertEquals((Object)new Long("<html><head /><body>The New, Better Index</body></html>".getBytes(Charsets.UTF_8).length), (Object)resource.getLength());
        PutTest.assertEquals((String)"text/html", (String)resource.getContentType());
        PutTest.assertEquals((String)"<html><head /><body>The New, Better Index</body></html>", (String)this.getContent(this.INDEX_HTML_URL));
    }

    public void testCreate() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX23_HTML_URL);
        String content = "<html><head /><body>The New, Better Index</body></html>";
        req.setBodyAsString("<html><head /><body>The New, Better Index</body></html>");
        req.setHeader("content-length", Integer.valueOf("<html><head /><body>The New, Better Index</body></html>".getBytes(Charsets.UTF_8).length).toString());
        req.setHeader("content-type", "text/html");
        WebdavPutAction action = new WebdavPutAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        PutTest.assertEquals((int)201, (int)res.getStatus());
        WebdavResource resource = this.factory.resolveResource(this.INDEX23_HTML_URL);
        PutTest.assertNotNull((Object)resource);
        PutTest.assertTrue((boolean)resource.exists());
        PutTest.assertEquals((Object)resource.getLength(), (Object)new Long("<html><head /><body>The New, Better Index</body></html>".getBytes(Charsets.UTF_8).length));
        PutTest.assertEquals((String)"text/html", (String)resource.getContentType());
        PutTest.assertEquals((String)"<html><head /><body>The New, Better Index</body></html>", (String)this.getContent(this.INDEX23_HTML_URL));
    }

    public void testTooLarge() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX23_HTML_URL);
        String content = "<html><head /><body>The New, Better Index</body></html>";
        req.setBodyAsString("<html><head /><body>The New, Better Index</body></html>");
        req.setHeader("content-length", Integer.valueOf("<html><head /><body>The New, Better Index</body></html>".getBytes(Charsets.UTF_8).length).toString());
        req.setHeader("content-type", "text/html");
        WebdavPutAction action = new WebdavPutAction(){

            public long getMaxSize() {
                return 1L;
            }
        };
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            PutTest.assertFalse((String)"Could upload", (boolean)true);
        }
        catch (WebdavProtocolException x) {
            PutTest.assertEquals((int)413, (int)x.getStatus());
        }
    }

    public void testInvalidParent() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(new WebdavPath((CharSequence)"notExists/lalala"));
        String content = "<html><head /><body>The New, Better Index</body></html>";
        req.setBodyAsString("<html><head /><body>The New, Better Index</body></html>");
        req.setHeader("content-length", Integer.valueOf("<html><head /><body>The New, Better Index</body></html>".getBytes(Charsets.UTF_8).length).toString());
        req.setHeader("content-type", "text/html");
        WebdavPutAction action = new WebdavPutAction();
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            PutTest.fail((String)"Expected 409 CONFLICT");
        }
        catch (WebdavProtocolException x) {
            PutTest.assertEquals((int)409, (int)x.getStatus());
        }
    }
}

