/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Charsets;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.versit.ICalendar;
import com.openexchange.tools.versit.VersionedObjectDefinition;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.converter.OXContainerConverter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;

public abstract class AbstractOXContainerConverterTest
extends TestCase {
    public static SessionObject getSession() throws Exception {
        UserStorage uStorage = UserStorage.getInstance();
        int userId = uStorage.getUserId(AjaxInit.getAJAXProperty("login"), (Context)new ContextImpl(1));
        SessionObject sessObj = SessionObjectWrapper.createSessionObject((int)userId, (int)1, (String)"csv-tests");
        return sessObj;
    }

    public static User getUserParticipant() throws OXException {
        UserStorage uStorage = UserStorage.getInstance();
        ContextImpl ctx = new ContextImpl(1);
        int uid = uStorage.getUserId(AjaxInit.getAJAXProperty("user_participant1"), (Context)ctx);
        return uStorage.getUser(uid, (Context)ctx);
    }

    public void setUp() throws Exception {
        Init.startServer();
    }

    public void tearDown() throws Exception {
        Init.stopServer();
    }

    public AbstractOXContainerConverterTest() {
    }

    public Task convertTask(String versitData) throws Exception {
        VersionedObjectDefinition def = ICalendar.definition;
        VersitDefinition.Reader versitReader = def.getReader((InputStream)new ByteArrayInputStream(versitData.getBytes(Charsets.UTF_8)), "UTF-8");
        VersitObject rootVersitObject = def.parseBegin(versitReader);
        VersitObject versitObject = def.parseChild(versitReader, rootVersitObject);
        OXContainerConverter oxContainerConverter = new OXContainerConverter((Session)AbstractOXContainerConverterTest.getSession());
        return oxContainerConverter.convertTask(versitObject);
    }

    public CalendarDataObject convertAppointment(String versitData) throws Exception {
        VersionedObjectDefinition def = ICalendar.definition;
        VersitDefinition.Reader versitReader = def.getReader((InputStream)new ByteArrayInputStream(versitData.getBytes(Charsets.UTF_8)), "UTF-8");
        VersitObject rootVersitObject = def.parseBegin(versitReader);
        VersitObject versitObject = def.parseChild(versitReader, rootVersitObject);
        OXContainerConverter oxContainerConverter = new OXContainerConverter((Session)AbstractOXContainerConverterTest.getSession());
        return oxContainerConverter.convertAppointment(versitObject);
    }

    public boolean isFlaggedAsPrivate(String versitData) throws Exception {
        VersionedObjectDefinition def = ICalendar.definition;
        VersitDefinition.Reader versitReader = def.getReader((InputStream)new ByteArrayInputStream(versitData.getBytes(Charsets.UTF_8)), "UTF-8");
        VersitObject rootVersitObject = def.parseBegin(versitReader);
        VersitObject versitObject = def.parseChild(versitReader, rootVersitObject);
        OXContainerConverter oxContainerConverter = new OXContainerConverter((Session)AbstractOXContainerConverterTest.getSession());
        CalendarDataObject appointmentObj = oxContainerConverter.convertAppointment(versitObject);
        return appointmentObj.getPrivateFlag();
    }

    public AbstractOXContainerConverterTest(String name) {
        super(name);
    }
}

