/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.google;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.participants.ConfirmStatus;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import com.openexchange.subscribe.google.AbstractGoogleSubscribeTest;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.json.JSONException;

public class GoogleSubscribeCalendarTest
extends AbstractGoogleSubscribeTest {
    public GoogleSubscribeCalendarTest(String name) {
        super(name);
    }

    public void testSingleAppointment() throws OXException, IOException, JSONException {
        String title = "Single appointment | 29 Jan 2014";
        Appointment appointment = this.fetchAppointment(this.getDateTime(29, 1, 2014, 13, 30), this.getDateTime(29, 1, 2014, 15, 30), "Single appointment | 29 Jan 2014", true);
        GoogleSubscribeCalendarTest.assertNotNull((String)"Appointment: 'Single appointment | 29 Jan 2014' not found", (Object)appointment);
        GoogleSubscribeCalendarTest.assertFieldNotNull("user id", 1, appointment.getUid());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("location", "Olpe, Deutschland", appointment.getLocation());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("note", "Single appointment | 29 Jan 2014\n\nSome text...", appointment.getNote());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("start date", this.getDateTime(29, 1, 2014, 13, 30, 0, TimeZone.getTimeZone("UTC")), appointment.getStartDate());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("timezone", "America/Santiago", appointment.getTimezone());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("end date", this.getDateTime(29, 1, 2014, 15, 30, 0, TimeZone.getTimeZone("UTC")), appointment.getEndDate());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("created by", this.client.getValues().getUserId(), appointment.getCreatedBy());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("alarm", 0, appointment.getAlarm());
        GoogleSubscribeCalendarTest.assertEquals((String)"This appointment has no confirmation, but the mapping exist", (int)0, (int)appointment.getConfirmations().length);
        GoogleSubscribeCalendarTest.assertNull((String)"This appointment has no participants, but the mapping exist", (Object)appointment.getParticipants());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("recurrence type", 0, appointment.getRecurrenceType());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("fulltime", false, appointment.getFullTime());
    }

    public void testAllDayAppointment() throws OXException, IOException, JSONException {
        String title = "All day appointment | 30 Jan 2014";
        Appointment appointment = this.fetchAppointment(this.getDateTime(28, 1, 2014, 0, 0, 0, TimeZone.getTimeZone("UTC")), this.getDateTime(29, 1, 2014, 0, 0, 0, TimeZone.getTimeZone("UTC")), "All day appointment | 30 Jan 2014", false);
        GoogleSubscribeCalendarTest.assertNotNull((String)"Appointment: 'All day appointment | 30 Jan 2014' not found", (Object)appointment);
        GoogleSubscribeCalendarTest.assertFieldNotNull("user id", 1, appointment.getUid());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("location", "Bremen, Deutschland", appointment.getLocation());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("note", "All day appointment | 30 Jan 2014", appointment.getNote());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("start date", this.getDateTime(28, 1, 2014, 0, 0, 0, TimeZone.getTimeZone("UTC")), appointment.getStartDate());
        GoogleSubscribeCalendarTest.assertEquals((String)"timezone", (String)this.client.getValues().getTimeZone().getID(), (String)appointment.getTimezone());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("end date", this.getDateTime(29, 1, 2014, 0, 0, 0, TimeZone.getTimeZone("UTC")), appointment.getEndDate());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("created by", this.client.getValues().getUserId(), appointment.getCreatedBy());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("alarm", 0, appointment.getAlarm());
        GoogleSubscribeCalendarTest.assertEquals((String)"This appointment has no confirmation, but the mapping exist", (int)0, (int)appointment.getConfirmations().length);
        GoogleSubscribeCalendarTest.assertNull((String)"This appointment has no participants, but the mapping exist", (Object)appointment.getParticipants());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("recurrence type", 0, appointment.getRecurrenceType());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("fulltime", true, appointment.getFullTime());
    }

    public void testDailyRecurrenceAppointment() throws OXException, IOException, JSONException {
        String title = "Daily recurrence appointment | 27 Jan 2014 - 14 March 2014";
        Appointment appointment = this.fetchAppointment(this.getDateTime(27, 1, 2014, 15, 30), this.getDateTime(27, 1, 2014, 17, 30), "Daily recurrence appointment | 27 Jan 2014 - 14 March 2014", true);
        GoogleSubscribeCalendarTest.assertNotNull((String)"Appointment: 'Daily recurrence appointment | 27 Jan 2014 - 14 March 2014' not found", (Object)appointment);
        GoogleSubscribeCalendarTest.assertFieldNotNull("user id", 1, appointment.getUid());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("location", "K\u00f6ln", appointment.getLocation());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("note", "Daily recurrence appointment | 27 Jan 2014 - 14 March 2014", appointment.getNote());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("start date", this.getDateTime(27, 1, 2014, 15, 30, 0, TimeZone.getTimeZone("UTC")), appointment.getStartDate());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("timezone", "Europe/Berlin", appointment.getTimezone());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("end date", this.getDateTime(27, 1, 2014, 17, 30, 0, TimeZone.getTimeZone("UTC")), appointment.getEndDate());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("created by", this.client.getValues().getUserId(), appointment.getCreatedBy());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("alarm", 0, appointment.getAlarm());
        GoogleSubscribeCalendarTest.assertEquals((String)"This appointment has no confirmation, but the mapping exist", (int)0, (int)appointment.getConfirmations().length);
        GoogleSubscribeCalendarTest.assertNull((String)"This appointment has no participants, but the mapping exist", (Object)appointment.getParticipants());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("fulltime", false, appointment.getFullTime());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("recurrence type", 2, appointment.getRecurrenceType());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("days", 62, appointment.getDays());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("interval", 1, appointment.getInterval());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("occurrence", 35, appointment.getOccurrence());
    }

    public void testMonthlyRecurrenceAppointment() throws OXException, IOException, JSONException {
        String title = "Every third month recurrence appointment | 15 March 2014 - Never ending";
        Appointment appointment = this.fetchAppointment(this.getDateTime(15, 3, 2014, 19, 0), this.getDateTime(15, 3, 2014, 21, 30), "Every third month recurrence appointment | 15 March 2014 - Never ending", true);
        GoogleSubscribeCalendarTest.assertNotNull((String)"Appointment: 'Every third month recurrence appointment | 15 March 2014 - Never ending' not found", (Object)appointment);
        GoogleSubscribeCalendarTest.assertFieldNotNull("user id", 1, appointment.getUid());
        GoogleSubscribeCalendarTest.assertFieldIsNull("location", appointment.getLocation());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("note", "Every third month recurrence appointment | 15 March 2014 - Never ending", appointment.getNote());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("start date", this.getDateTime(15, 3, 2014, 19, 0, 0, TimeZone.getTimeZone("UTC")), appointment.getStartDate());
        GoogleSubscribeCalendarTest.assertEquals((String)"timezone", (String)this.client.getValues().getTimeZone().getID(), (String)appointment.getTimezone());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("end date", this.getDateTime(15, 3, 2014, 21, 30, 0, TimeZone.getTimeZone("UTC")), appointment.getEndDate());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("created by", this.client.getValues().getUserId(), appointment.getCreatedBy());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("alarm", 10, appointment.getAlarm());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("fulltime", false, appointment.getFullTime());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("recurrence type", 3, appointment.getRecurrenceType());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("day in month", 15, appointment.getDayInMonth());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("interval", 3, appointment.getInterval());
        GoogleSubscribeCalendarTest.assertEquals((String)"occurrence", (int)0, (int)appointment.getOccurrence());
        GoogleSubscribeCalendarTest.assertEquals((String)"days", (int)0, (int)appointment.getDays());
        GoogleSubscribeCalendarTest.assertEquals((String)"This appointment has no confirmation, but the mapping exist", (int)0, (int)appointment.getConfirmations().length);
        GoogleSubscribeCalendarTest.assertNull((String)"This appointment has no participants, but the mapping exist", (Object)appointment.getParticipants());
    }

    public void testYearlyRecurrenceAppointment() throws OXException, IOException, JSONException {
        String title = "Yearly recurrence appointment | 14 March 2014 - 14 March 2016";
        Appointment appointment = this.fetchAppointment(this.getDateTime(14, 3, 2014, 19, 0), this.getDateTime(14, 3, 2014, 20, 30), "Yearly recurrence appointment | 14 March 2014 - 14 March 2016", true);
        GoogleSubscribeCalendarTest.assertNotNull((String)"Appointment: 'Yearly recurrence appointment | 14 March 2014 - 14 March 2016' not found", (Object)appointment);
        GoogleSubscribeCalendarTest.assertFieldNotNull("user id", 1, appointment.getUid());
        GoogleSubscribeCalendarTest.assertFieldIsNull("location", appointment.getLocation());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("note", "Yearly recurrence appointment | 14 March 2014 - 14 March 2016", appointment.getNote());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("start date", this.getDateTime(14, 3, 2014, 19, 0, 0, TimeZone.getTimeZone("UTC")), appointment.getStartDate());
        GoogleSubscribeCalendarTest.assertEquals((String)"timezone", (String)this.client.getValues().getTimeZone().getID(), (String)appointment.getTimezone());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("end date", this.getDateTime(14, 3, 2014, 20, 30, 0, TimeZone.getTimeZone("UTC")), appointment.getEndDate());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("created by", this.client.getValues().getUserId(), appointment.getCreatedBy());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("alarm", 10, appointment.getAlarm());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("fulltime", false, appointment.getFullTime());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("recurrence type", 4, appointment.getRecurrenceType());
        GoogleSubscribeCalendarTest.assertEquals((String)"days", (int)0, (int)appointment.getDays());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("interval", 1, appointment.getInterval());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("occurrence", 2, appointment.getOccurrence());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("day in month", 14, appointment.getDayInMonth());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("month", 2, appointment.getMonth());
        GoogleSubscribeCalendarTest.assertEquals((String)"This appointment has no confirmation, but the mapping exist", (int)0, (int)appointment.getConfirmations().length);
        GoogleSubscribeCalendarTest.assertNull((String)"This appointment has no participants, but the mapping exist", (Object)appointment.getParticipants());
    }

    public void testAppointmentWithExceptions() throws OXException, IOException, JSONException {
        String title = "Every two days recurrence appointment with exception | 14 March 2014 - Never ending";
        Appointment appointment = this.fetchAppointment(this.getDateTime(14, 3, 2014, 12, 0), this.getDateTime(14, 3, 2014, 14, 0), "Every two days recurrence appointment with exception | 14 March 2014 - Never ending", true);
        GoogleSubscribeCalendarTest.assertNotNull((String)"Appointment: 'Every two days recurrence appointment with exception | 14 March 2014 - Never ending' not found", (Object)appointment);
        GoogleSubscribeCalendarTest.assertFieldNotNull("user id", 1, appointment.getUid());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("location", "Hannover, Deutschland", appointment.getLocation());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("note", "Every two days recurrence appointment with exception | 14 March 2014 - Never ending\nDonnerstag 20.03. ChangeException\nMittwoch 26.03. DeleteException", appointment.getNote());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("start date", this.getDateTime(14, 3, 2014, 12, 0, 0, TimeZone.getTimeZone("UTC")), appointment.getStartDate());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("timezone", "Europe/Berlin", appointment.getTimezone());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("end date", this.getDateTime(14, 3, 2014, 14, 0, 0, TimeZone.getTimeZone("UTC")), appointment.getEndDate());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("created by", this.client.getValues().getUserId(), appointment.getCreatedBy());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("alarm", 30, appointment.getAlarm());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("fulltime", false, appointment.getFullTime());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("recurrence type", 1, appointment.getRecurrenceType());
        GoogleSubscribeCalendarTest.assertEquals((String)"days", (int)0, (int)appointment.getDays());
        GoogleSubscribeCalendarTest.assertNotNullAndEquals("interval", 2, appointment.getInterval());
        GoogleSubscribeCalendarTest.assertEquals((String)"occurrence", (int)0, (int)appointment.getOccurrence());
        HashMap<String, Part> participants = new HashMap<String, Part>();
        participants.put("ewaldbartkowiak@gmail.com", new Part("ewaldbartkowiak@gmail.com", 5, ConfirmStatus.ACCEPT));
        participants.put("dimitribronkowitsch@googlemail.com", new Part("dimitribronkowitsch@googlemail.com", 5, ConfirmStatus.NONE));
        int externals = 0;
        GoogleSubscribeCalendarTest.assertNotNull((Object)appointment.getConfirmations());
        for (ConfirmableParticipant cp : appointment.getConfirmations()) {
            Part p = (Part)participants.get(cp.getEmailAddress());
            if (p == null || !p.getEmailAddress().equals(cp.getEmailAddress())) continue;
            GoogleSubscribeCalendarTest.assertNotNull((String)("No participant found with email address " + cp.getEmailAddress()), (Object)p);
            GoogleSubscribeCalendarTest.assertNotNullAndEquals("particiant email address", p.getEmailAddress(), cp.getEmailAddress());
            GoogleSubscribeCalendarTest.assertFieldNotNull("participant status", p.getConfirmStatus(), cp.getStatus());
            GoogleSubscribeCalendarTest.assertNotNullAndEquals("particiant status id", p.getConfirmStatus().getId(), cp.getStatus().getId());
            GoogleSubscribeCalendarTest.assertNotNullAndEquals("participant type", p.getParticipantType(), cp.getType());
            ++externals;
        }
        GoogleSubscribeCalendarTest.assertEquals((String)"External participants are not equal", (int)2, (int)externals);
    }

    private Appointment fetchAppointment(Date startDate, Date endDate, String title, boolean reccurence) {
        Appointment[] appointments;
        int folderId = this.getCalendarTestFolderID();
        for (Appointment a : appointments = this.getCalendarManager().all(folderId, startDate, endDate, Appointment.ALL_COLUMNS, reccurence)) {
            if (!a.getTitle().equals(title)) continue;
            return a;
        }
        return null;
    }

    private class Part {
        private String emailAddress;
        private int participantType;
        private ConfirmStatus confirmStatus;

        public Part(String emailAddress, int participantType, ConfirmStatus confirmStatus) {
            this.emailAddress = emailAddress;
            this.participantType = participantType;
            this.confirmStatus = confirmStatus;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public int getParticipantType() {
            return this.participantType;
        }

        public ConfirmStatus getConfirmStatus() {
            return this.confirmStatus;
        }
    }
}

