/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import java.util.ArrayList;

public class OverridingUserConfigurationStorage
extends UserConfigurationStorage {
    protected final UserConfigurationStorage delegate;

    public OverridingUserConfigurationStorage(UserConfigurationStorage delegate) {
        this.delegate = delegate;
    }

    protected void startInternal() throws OXException {
        this.delegate.startInternal();
    }

    protected void stopInternal() throws OXException {
        this.delegate.stopInternal();
    }

    public UserConfiguration getUserConfiguration(int userId, int[] groups, Context ctx) throws OXException {
        UserConfiguration config = this.getOverride(userId, groups, ctx);
        return config == null ? this.delegate.getUserConfiguration(userId, groups, ctx) : config;
    }

    public UserConfiguration[] getUserConfiguration(Context ctx, User[] users) throws OXException {
        ArrayList<UserConfiguration> retval = new ArrayList<UserConfiguration>();
        for (User user : users) {
            retval.add(this.getUserConfiguration(user.getId(), user.getGroups(), ctx));
        }
        return retval.toArray(new UserConfiguration[retval.size()]);
    }

    public UserConfiguration[] getUserConfigurations(Context ctx, int[] userIds, int[][] groups) throws OXException {
        ArrayList<UserConfiguration> retval = new ArrayList<UserConfiguration>();
        for (int i = 0; i < userIds.length; ++i) {
            retval.add(this.getUserConfiguration(userIds[i], groups[i], ctx));
        }
        return retval.toArray(new UserConfiguration[retval.size()]);
    }

    public void clearStorage() throws OXException {
        this.delegate.clearStorage();
    }

    public void invalidateCache(int userId, Context ctx) throws OXException {
        this.delegate.invalidateCache(userId, ctx);
    }

    public UserConfiguration getOverride(int userId, int[] groups, Context ctx) throws OXException {
        return null;
    }

    public UserConfiguration getOverride(int userId, int[] groups, Context ctx, boolean initExtendedPermissions) throws OXException {
        return null;
    }

    public void override() throws OXException {
        UserConfigurationStorage.setInstance((UserConfigurationStorage)this);
    }

    public void takeBack() throws OXException {
        UserConfigurationStorage.setInstance((UserConfigurationStorage)this.delegate);
    }
}

