/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tx;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.contexts.Context;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class ConfigurableDBProvider
implements DBProvider {
    private String url;
    private String driver;
    private String login;
    private String password;

    public Connection getReadConnection(Context ctx) {
        try {
            return DriverManager.getConnection(this.url, this.login, this.password);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public void releaseReadConnection(Context ctx, Connection con) {
        if (con == null) {
            return;
        }
        try {
            if (!con.isClosed()) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Connection getWriteConnection(Context ctx) {
        return this.getReadConnection(ctx);
    }

    public void releaseWriteConnection(Context ctx, Connection con) {
        this.releaseReadConnection(ctx, con);
    }

    public void releaseWriteConnectionAfterReading(Context ctx, Connection con) {
        this.releaseReadConnection(ctx, con);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) throws ClassNotFoundException {
        Class.forName(driver);
        this.driver = driver;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

