/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DatabaseImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class InMemoryInfostoreDatabase
extends DatabaseImpl {
    private final Map<Context, Map<Integer, List<DocumentMetadata>>> data = new HashMap<Context, Map<Integer, List<DocumentMetadata>>>();
    private final Map<Context, List<DocumentMetadata>> changes = new HashMap<Context, List<DocumentMetadata>>();
    private final Map<Context, List<DocumentMetadata>> deletions = new HashMap<Context, List<DocumentMetadata>>();
    private final Map<Context, List<DocumentMetadata>> creations = new HashMap<Context, List<DocumentMetadata>>();

    public void put(Context ctx, DocumentMetadata dm) {
        List<DocumentMetadata> versions = this.getVersions(ctx, dm.getId());
        this.assureSize(versions, dm.getVersion());
        versions.set(dm.getVersion(), dm);
    }

    private void assureSize(List<DocumentMetadata> versions, int index) {
        while (index >= versions.size()) {
            versions.add(null);
        }
    }

    public int getNextVersionNumber(Context ctx, int id) {
        return this.getVersions(ctx, id).size();
    }

    private List<DocumentMetadata> getVersions(Context ctx, int id) {
        Map<Integer, List<DocumentMetadata>> ctxMap = this.getCtxMap(ctx);
        if (ctxMap.containsKey(Autoboxing.I((int)id))) {
            return ctxMap.get(Autoboxing.I((int)id));
        }
        ArrayList<DocumentMetadata> dms = new ArrayList<DocumentMetadata>();
        ctxMap.put(Autoboxing.I((int)id), dms);
        return dms;
    }

    private Map<Integer, List<DocumentMetadata>> getCtxMap(Context ctx) {
        if (this.data.containsKey(ctx)) {
            return this.data.get(ctx);
        }
        HashMap<Integer, List<DocumentMetadata>> versions = new HashMap<Integer, List<DocumentMetadata>>();
        this.data.put(ctx, versions);
        return versions;
    }

    public boolean exists(int id, int version, Context ctx) {
        throw new UnsupportedOperationException();
    }

    public DocumentMetadata getDocumentMetadata(int id, int version, Context ctx) {
        throw new UnsupportedOperationException();
    }

    public List<DocumentMetadata> getAllVersions(Context ctx, Metadata[] columns, String where) {
        throw new UnsupportedOperationException();
    }

    public List<DocumentMetadata> getAllDocuments(Context ctx, Metadata[] columns, String where) {
        throw new UnsupportedOperationException();
    }

    public InputStream getDocument(int id, int version, Context ctx) {
        throw new UnsupportedOperationException();
    }

    public int[] removeDocument(String identifier, Context ctx) {
        for (List<DocumentMetadata> versions : this.getCtxMap(ctx).values()) {
            for (DocumentMetadata metadata : versions) {
                String location = metadata.getFilestoreLocation();
                if (location == null || !location.equals(identifier)) continue;
                this.deletions.get(ctx).add(metadata);
                return new int[]{1, 1};
            }
        }
        return new int[]{1, 1};
    }

    public int modifyDocument(String oldidentifier, String newidentifier, String description, String mimetype, Context ctx) {
        for (List<DocumentMetadata> versions : this.getCtxMap(ctx).values()) {
            for (DocumentMetadata metadata : versions) {
                String location = metadata.getFilestoreLocation();
                if (location == null || !location.equals(oldidentifier)) continue;
                metadata.setFilestoreLocation(newidentifier);
                metadata.setDescription(description);
                metadata.setFileMIMEType(mimetype);
                this.changes.get(ctx).add(metadata);
                return metadata.getId();
            }
        }
        return -1;
    }

    public int[] saveDocumentMetadata(String identifier, DocumentMetadata document, User user, Context ctx) {
        document.setFilestoreLocation(identifier);
        this.creations.get(ctx).add(document);
        return new int[]{1, 1, 1};
    }

    public SortedSet<String> getDocumentFileStoreLocationsperContext(Context ctx) {
        TreeSet<String> locations = new TreeSet<String>();
        for (List<DocumentMetadata> versions : this.getCtxMap(ctx).values()) {
            for (DocumentMetadata metadata : versions) {
                String location = metadata.getFilestoreLocation();
                if (location == null) continue;
                locations.add(location);
            }
        }
        return locations;
    }

    public TimedResult<DocumentMetadata> getVersions(int id, Metadata[] columns, Metadata sort, int order, Context ctx) {
        throw new UnsupportedOperationException();
    }

    public TimedResult<DocumentMetadata> getDocuments(int[] ids, Metadata[] columns, Context ctx) {
        throw new UnsupportedOperationException();
    }

    public int countDocuments(long folderId, boolean onlyOwnObjects, Context ctx, User user) {
        throw new UnsupportedOperationException();
    }

    public int countDocumentsperContext(Context ctx) {
        throw new UnsupportedOperationException();
    }

    public boolean hasFolderForeignObjects(long folderId, Context ctx, User user) {
        throw new UnsupportedOperationException();
    }

    public boolean isFolderEmpty(long folderId, Context ctx) {
        throw new UnsupportedOperationException();
    }

    public void removeUser(int id, Context ctx, ServerSession session, EntityLockManager locks) {
        throw new UnsupportedOperationException();
    }

    protected FileStorage getFileStorage(Context ctx) {
        throw new UnsupportedOperationException();
    }

    public void startTransaction() {
    }

    public void commit() {
    }

    public void finish() {
    }

    public void rollback() {
    }

    public int getMaxActiveVersion(int id, Context context, List<DocumentMetadata> ignoreVersions) {
        throw new UnsupportedOperationException();
    }

    public DBProvider getProvider() {
        throw new UnsupportedOperationException();
    }

    public void setProvider(DBProvider provider) {
    }

    public Connection getReadConnection(Context ctx) {
        throw new UnsupportedOperationException();
    }

    public Connection getWriteConnection(Context ctx) {
        throw new UnsupportedOperationException();
    }

    public void releaseReadConnection(Context ctx, Connection con) {
        throw new UnsupportedOperationException();
    }

    public void releaseWriteConnection(Context ctx, Connection con) {
        throw new UnsupportedOperationException();
    }

    public void commitDBTransaction() {
        throw new UnsupportedOperationException();
    }

    public void rollbackDBTransaction() {
        throw new UnsupportedOperationException();
    }

    public void startDBTransaction() {
    }

    public void forgetChanges(Context ctx) {
        this.changes.put(ctx, new ArrayList());
    }

    public List<DocumentMetadata> getChanges(Context ctx) {
        if (!this.changes.containsKey(ctx)) {
            return new ArrayList<DocumentMetadata>();
        }
        return this.changes.get(ctx);
    }

    public void forgetDeletions(Context ctx) {
        this.deletions.put(ctx, new ArrayList());
    }

    public List<DocumentMetadata> getDeletions(Context ctx) {
        return this.deletions.get(ctx);
    }

    public void forgetCreated(Context ctx) {
        this.creations.put(ctx, new ArrayList());
    }

    public List<DocumentMetadata> getCreated(Context ctx) {
        return this.creations.get(ctx);
    }

    public void setRequestTransactional(boolean transactional) {
    }
}

