/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.data.conversion.ical.ical4j.internal.calendar.Participants;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.importexport.AbstractICalImportTest;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.importexport.formats.Format;
import com.openexchange.session.Session;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class Bug8475
extends AbstractICalImportTest {
    public static Test suite() {
        return new JUnit4TestAdapter(Bug8475.class);
    }

    @org.junit.Test
    public void testAttendeeNotFound() throws OXException, UnsupportedEncodingException, SQLException, OXException, NumberFormatException, OXException, OXException {
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 1.5//EN\nBEGIN:VTODO\nORGANIZER:MAILTO:tobias.friedrich@open-xchange.com\nATTENDEE:MAILTO:tobias.prinz@open-xchange.com\nDTSTART:20070608T080000Z\nSTATUS:COMPLETED\nSUMMARY:Test todo\nUID:8D4FFA7A-ABC0-11D7-8200-00306571349C-RID\nDUE:20070618T080000Z\nEND:VTODO\nEND:VCALENDAR";
        ImportResult res = this.performOneEntryCheck("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 1.5//EN\nBEGIN:VTODO\nORGANIZER:MAILTO:tobias.friedrich@open-xchange.com\nATTENDEE:MAILTO:tobias.prinz@open-xchange.com\nDTSTART:20070608T080000Z\nSTATUS:COMPLETED\nSUMMARY:Test todo\nUID:8D4FFA7A-ABC0-11D7-8200-00306571349C-RID\nDUE:20070618T080000Z\nEND:VTODO\nEND:VCALENDAR", Format.ICAL, 1, "8475", ctx, false);
        TasksSQLImpl tasks = new TasksSQLImpl((Session)sessObj);
        Task task = tasks.getTaskById(Integer.valueOf(res.getObjectId()).intValue(), Integer.valueOf(res.getFolder()).intValue());
        Participant[] participants = task.getParticipants();
        Assert.assertEquals((String)"One participant?", (long)1L, (long)participants.length);
        boolean found = false;
        for (Participant p : participants) {
            if (!"tobias.prinz@open-xchange.com".equals(p.getEmailAddress())) continue;
            found = true;
        }
        Assert.assertTrue((String)"Found attendee?", (boolean)found);
    }

    @org.junit.Test
    public void testInternalAttendee() throws Exception {
        User testUser = Bug8475.getUserParticipant();
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Apple Computer\\, Inc//iCal 1.5//EN\nBEGIN:VTODO\nORGANIZER:MAILTO:tobias.friedrich@open-xchange.com\nATTENDEE:MAILTO:" + testUser.getMail() + "\n" + "DTSTART:20070608T080000Z\n" + "STATUS:COMPLETED\n" + "SUMMARY:Test todo\n" + "UID:8D4FFA7A-ABC0-11D7-8200-00306571349C-RID\n" + "DUE:20070618T080000Z\n" + "END:VTODO\n" + "END:VCALENDAR";
        ImportResult res = this.performOneEntryCheck(ical, Format.ICAL, 1, "8475", ctx, false);
        TasksSQLImpl tasks = new TasksSQLImpl((Session)sessObj);
        Task task = tasks.getTaskById(Integer.valueOf(res.getObjectId()).intValue(), Integer.valueOf(res.getFolder()).intValue());
        Participant[] participants = task.getParticipants();
        Assert.assertEquals((String)"One participant?", (long)1L, (long)participants.length);
        Participant p = participants[0];
        User user = Participants.userResolver.loadUser(testUser.getId(), ctx);
        Assert.assertEquals((String)("User \"" + testUser.getMail() + "\"" + testUser.getMail().length() + " gets participant \"" + p + "\"" + p.toString().length() + ". using resolver " + Participants.userResolver + "\"" + user + "\""), (long)testUser.getId(), (long)p.getIdentifier());
    }
}

