/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.groupware.contact.helpers.UseCountGlobalFirstComparator;
import com.openexchange.groupware.container.Contact;
import junit.framework.TestCase;

public class UseCountGlobalFirstComparatorTest
extends TestCase {
    public void testGlobalUserFolderBeforeRegularFolder() {
        Contact inGlobalFolder = new Contact();
        inGlobalFolder.setObjectID(1);
        inGlobalFolder.setParentFolderID(6);
        inGlobalFolder.setUseCount(0);
        Contact notInGlobalFolder = new Contact();
        notInGlobalFolder.setObjectID(2);
        notInGlobalFolder.setParentFolderID(23);
        notInGlobalFolder.setUseCount(200000);
        this.assertBigger(inGlobalFolder, notInGlobalFolder);
    }

    public void testGlobalUserFoldersByUseCount() {
        Contact lowUseCount = new Contact();
        lowUseCount.setObjectID(1);
        lowUseCount.setParentFolderID(6);
        lowUseCount.setUseCount(0);
        Contact highUseCount = new Contact();
        highUseCount.setObjectID(2);
        highUseCount.setParentFolderID(6);
        highUseCount.setUseCount(200000);
        this.assertBigger(highUseCount, lowUseCount);
    }

    public void testRegularFoldersByUseCount() {
        Contact lowUseCount = new Contact();
        lowUseCount.setObjectID(1);
        lowUseCount.setParentFolderID(23);
        lowUseCount.setUseCount(0);
        Contact highUseCount = new Contact();
        highUseCount.setObjectID(2);
        highUseCount.setParentFolderID(23);
        highUseCount.setUseCount(200000);
        this.assertBigger(highUseCount, lowUseCount);
    }

    private void assertBigger(Contact c1, Contact c2) {
        UseCountGlobalFirstComparatorTest.assertTrue((String)"c1 was lower or equal than c2", (0 < new UseCountGlobalFirstComparator().compare(c1, c2) ? 1 : 0) != 0);
    }
}

