/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Bug21177Test
extends CardDAVTest {
    public Bug21177Test(String name) {
        super(name);
    }

    public void testAddSpecialCharacters() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug21177Test.randomUID();
        String firstName = "\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5";
        String lastName = "test";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:test;\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5;;;\r\nFN:\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5 test\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        Bug21177Test.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Bug21177Test.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        Bug21177Test.assertEquals((String)"firstname wrong", (String)"\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5", (String)contact.getGivenName());
        Bug21177Test.assertEquals((String)"lastname wrong", (String)"test", (String)contact.getSurName());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Bug21177Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug21177Test.assertContains(uid, addressData);
        Bug21177Test.assertEquals((String)"N wrong", (String)"\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5", (String)card.getGivenName());
        Bug21177Test.assertEquals((String)"N wrong", (String)"test", (String)card.getFamilyName());
        Bug21177Test.assertEquals((String)"FN wrong", (String)"\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5 test", (String)card.getFN());
    }
}

