/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database;

import com.openexchange.java.ConcurrentHashSet;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConfigDBUniqueIDTest {
    private static final String URL = "jdbc:mysql://devel-master.netline.de/configdb";
    private static final Properties PROPS = new Properties();
    private static int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setup() throws SQLException {
        Connection con = null;
        Statement stmt = null;
        ResultSet result = null;
        try {
            con = ConfigDBUniqueIDTest.createConnection();
            con.setAutoCommit(false);
            stmt = con.createStatement();
            result = stmt.executeQuery("SELECT id FROM configdb_sequence FOR UPDATE");
            if (result.next()) {
                id = result.getInt(1);
            }
            con.commit();
        }
        catch (Throwable throwable) {
            ConfigDBUniqueIDTest.closeSQLStuff(result, stmt);
            ConfigDBUniqueIDTest.autocommit(con);
            if (null != con) {
                con.close();
            }
            throw throwable;
        }
        ConfigDBUniqueIDTest.closeSQLStuff(result, stmt);
        ConfigDBUniqueIDTest.autocommit(con);
        if (null != con) {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void shutdown() throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            con = ConfigDBUniqueIDTest.createConnection();
            con.setAutoCommit(false);
            stmt = con.prepareStatement("UPDATE configdb_sequence SET id=?");
            stmt.setInt(1, id);
            stmt.executeUpdate();
            con.commit();
        }
        catch (Throwable throwable) {
            ConfigDBUniqueIDTest.closeSQLStuff(result, stmt);
            ConfigDBUniqueIDTest.autocommit(con);
            if (null != con) {
                con.close();
            }
            throw throwable;
        }
        ConfigDBUniqueIDTest.closeSQLStuff(result, stmt);
        ConfigDBUniqueIDTest.autocommit(con);
        if (null != con) {
            con.close();
        }
    }

    @Test
    public void checkForWrongIds() throws SQLException, InterruptedException {
        int size = 2;
        Thread[] threads = new Thread[size];
        Generator[] generators = new Generator[size];
        ConcurrentHashSet generated = new ConcurrentHashSet(1000);
        for (int i = 0; i < size; ++i) {
            generators[i] = new Generator(ConfigDBUniqueIDTest.createConnection(), (Set<Integer>)generated);
            threads[i] = new Thread(generators[i]);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        Thread.sleep(10000L);
        for (Runnable runnable : generators) {
            ((Generator)runnable).stop();
        }
        for (Runnable runnable : threads) {
            ((Thread)runnable).join();
        }
        for (Runnable runnable : generators) {
            Exception e = ((Generator)runnable).getException();
            if (null == e) continue;
            Assert.fail((String)e.getMessage());
        }
    }

    private static Connection createConnection() throws SQLException {
        return DriverManager.getConnection(URL, PROPS);
    }

    static void closeSQLStuff(ResultSet result, Statement stmt) throws SQLException {
        if (null != result) {
            result.close();
        }
        if (null != stmt) {
            stmt.close();
        }
    }

    static void autocommit(Connection con) throws SQLException {
        if (null != con) {
            con.setAutoCommit(true);
        }
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(ConfigDBUniqueIDTest.class);
    }

    static {
        PROPS.put("user", "openexchange");
        PROPS.put("password", "secret");
        PROPS.put("useUnicode", "true");
        PROPS.put("characterEncoding", "UTF-8");
        PROPS.put("autoReconnect", "true");
        PROPS.put("useServerPrepStmts", "false");
        PROPS.put("useTimezone", "true");
        PROPS.put("serverTimezone", "UTC");
        PROPS.put("connectTimeout", "15000");
        PROPS.put("socketTimeout", "15000");
    }

    private class Generator
    implements Runnable {
        private final Connection con;
        private final Set<Integer> generated;
        private boolean run;
        private Exception e;

        public Generator(Connection con, Set<Integer> generated) {
            this.con = con;
            this.generated = generated;
            this.run = true;
        }

        public void stop() {
            this.run = false;
        }

        public Exception getException() {
            return this.e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.run) {
                    int newId = -1;
                    try {
                        this.con.setAutoCommit(false);
                        PreparedStatement stmt = null;
                        ResultSet result = null;
                        try {
                            stmt = this.con.prepareStatement("UPDATE configdb_sequence SET id=last_insert_id(id+1)");
                            stmt.execute();
                            stmt.close();
                            stmt = this.con.prepareStatement("SELECT last_insert_id()");
                            result = stmt.executeQuery();
                            if (result.next()) {
                                newId = result.getInt(1);
                            }
                        }
                        catch (Throwable throwable) {
                            ConfigDBUniqueIDTest.closeSQLStuff(result, stmt);
                            throw throwable;
                        }
                        ConfigDBUniqueIDTest.closeSQLStuff(result, stmt);
                        this.con.commit();
                    }
                    finally {
                        ConfigDBUniqueIDTest.autocommit(this.con);
                    }
                    if (this.generated.add(newId)) continue;
                    throw new Exception("Generated duplicate identifier " + newId);
                }
            }
            catch (Exception e1) {
                this.e = e1;
            }
        }
    }
}

