/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.storage;

import com.openexchange.contact.Data;
import com.openexchange.contact.storage.ContactStorageTest;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.junit.Test;

public class UpdateTest
extends ContactStorageTest {
    @Test
    public void testUpdateSimple() throws Exception {
        String folderId = "500002";
        Contact contact = new Contact();
        contact.setCreatedBy(this.getUserID());
        contact.setDisplayName("Otto Maier");
        contact.setGivenName("Otto");
        contact.setSurName("Maier");
        contact.setEmail1("otto.maier@example.com");
        contact.setUid(UUID.randomUUID().toString());
        this.getStorage().create(this.getSession(), "500002", contact);
        super.rememberForCleanUp(contact);
        Contact savedContact = super.findContact(contact.getUid(), "500002");
        UpdateTest.assertNotNull((String)"contact not found", (Object)savedContact);
        UpdateTest.assertEquals((String)"display name wrong", (String)contact.getDisplayName(), (String)savedContact.getDisplayName());
        UpdateTest.assertEquals((String)"surname wrong", (String)contact.getSurName(), (String)savedContact.getSurName());
        UpdateTest.assertEquals((String)"givenname wrong", (String)contact.getGivenName(), (String)savedContact.getGivenName());
        UpdateTest.assertEquals((String)"email1 wrong", (String)contact.getEmail1(), (String)savedContact.getEmail1());
        Date clientLastModified = savedContact.getLastModified();
        savedContact.setDisplayName("Otto2 Maier2");
        savedContact.setGivenName("Otto2");
        savedContact.setSurName("Maier2");
        savedContact.setEmail1("otto2.maier2@example.com");
        String objectID = Integer.toString(savedContact.getObjectID());
        this.getStorage().update(this.getSession(), "500002", objectID, savedContact, clientLastModified);
        super.rememberForCleanUp(contact);
        Contact updatedContact = super.findContact(savedContact.getUid(), "500002", clientLastModified);
        UpdateTest.assertNotNull((String)"contact not found", (Object)updatedContact);
        UpdateTest.assertEquals((String)"display name wrong", (String)updatedContact.getDisplayName(), (String)savedContact.getDisplayName());
        UpdateTest.assertEquals((String)"surname wrong", (String)updatedContact.getSurName(), (String)savedContact.getSurName());
        UpdateTest.assertEquals((String)"givenname wrong", (String)updatedContact.getGivenName(), (String)savedContact.getGivenName());
        UpdateTest.assertEquals((String)"email1 wrong", (String)updatedContact.getEmail1(), (String)savedContact.getEmail1());
    }

    @Test
    public void testUpdateImage() throws Exception {
        String folderId = "500004";
        Contact contact = new Contact();
        contact.setCreatedBy(this.getUserID());
        contact.setDisplayName("Dirk Dampf");
        contact.setGivenName("Dirk");
        contact.setSurName("Dampf");
        contact.setEmail1("dirk.dampf@example.com");
        contact.setUid(UUID.randomUUID().toString());
        contact.setImage1(Data.image);
        contact.setImageContentType("image/png");
        this.getStorage().create(this.getSession(), "500004", contact);
        super.rememberForCleanUp(contact);
        Contact savedContact = super.findContact(contact.getUid(), "500004");
        UpdateTest.assertNotNull((String)"contact not found", (Object)savedContact);
        UpdateTest.assertNotNull((String)"no image found", (Object)savedContact.getImage1());
        UpdateTest.assertEquals((String)"number of images wrong", (int)1, (int)savedContact.getNumberOfImages());
        UpdateTest.assertTrue((String)"image wrong", (boolean)Arrays.equals(contact.getImage1(), savedContact.getImage1()));
        UpdateTest.assertEquals((String)"image content type wrong", (String)contact.getImageContentType(), (String)savedContact.getImageContentType());
        Date clientLastModified = savedContact.getLastModified();
        Arrays.sort(savedContact.getImage1());
        String objectID = Integer.toString(savedContact.getObjectID());
        this.getStorage().update(this.getSession(), "500004", objectID, savedContact, clientLastModified);
        super.rememberForCleanUp(contact);
        Contact updatedContact = super.findContact(savedContact.getUid(), "500004", clientLastModified);
        UpdateTest.assertNotNull((String)"contact not found", (Object)updatedContact);
        UpdateTest.assertNotNull((String)"no image found", (Object)updatedContact.getImage1());
        UpdateTest.assertEquals((String)"number of images wrong", (int)1, (int)updatedContact.getNumberOfImages());
        UpdateTest.assertTrue((String)"image wrong", (boolean)Arrays.equals(savedContact.getImage1(), updatedContact.getImage1()));
        UpdateTest.assertEquals((String)"image content type wrong", (String)savedContact.getImageContentType(), (String)updatedContact.getImageContentType());
    }

    public void testUpdateDistList() throws Exception {
        String folderId = "500003";
        Contact contact = new Contact();
        contact.setCreatedBy(this.getUserID());
        contact.setSurName("Distributionlist 52");
        contact.setUid(UUID.randomUUID().toString());
        contact.setDistributionList(new DistributionListEntryObject[]{new DistributionListEntryObject("Horst Hund", "horst.hund@example.com", 0), new DistributionListEntryObject("Werner Hund", "werner.hund@example.com", 0), new DistributionListEntryObject("Dieter Hund", "dieter.hund@example.com", 0), new DistributionListEntryObject("Klaus Hund", "klaus.hund@example.com", 0), new DistributionListEntryObject("Kurt Hund", "kurt.hund@example.com", 0)});
        this.getStorage().create(this.getSession(), "500003", contact);
        super.rememberForCleanUp(contact);
        Contact savedContact = super.findContact(contact.getUid(), "500003");
        UpdateTest.assertNotNull((String)"contact not found", (Object)savedContact);
        UpdateTest.assertTrue((String)"not marked as distribution list", (boolean)savedContact.getMarkAsDistribtuionlist());
        UpdateTest.assertNotNull((String)"distribution list not found", (Object)savedContact.getDistributionList());
        UpdateTest.assertEquals((String)"number of distribution list members wrong", (int)5, (int)savedContact.getNumberOfDistributionLists());
        UpdateTest.assertEquals((String)"number of distribution list members wrong", (int)5, (int)savedContact.getDistributionList().length);
        UpdateTest.assertTrue((String)"distribution list wrong", (boolean)Arrays.equals(contact.getDistributionList(), savedContact.getDistributionList()));
        Date clientLastModified = savedContact.getLastModified();
        savedContact.setDistributionList(new DistributionListEntryObject[]{new DistributionListEntryObject("Horst Klotz", "horst.klotz@example.com", 0), new DistributionListEntryObject("Werner Klotz", "werner.klotz@example.com", 0), new DistributionListEntryObject("Klaus Klotz", "klaus.klotz@example.com", 0), new DistributionListEntryObject("Kurt Klotz", "kurt.klotz@example.com", 0)});
        String objectID = Integer.toString(savedContact.getObjectID());
        this.getStorage().update(this.getSession(), "500003", objectID, savedContact, clientLastModified);
        super.rememberForCleanUp(contact);
        Contact updatedContact = super.findContact(savedContact.getUid(), "500003", clientLastModified);
        UpdateTest.assertNotNull((String)"contact not found", (Object)updatedContact);
        UpdateTest.assertTrue((String)"not marked as distribution list", (boolean)updatedContact.getMarkAsDistribtuionlist());
        UpdateTest.assertNotNull((String)"distribution list not found", (Object)updatedContact.getDistributionList());
        UpdateTest.assertEquals((String)"number of distribution list members wrong", (int)4, (int)updatedContact.getNumberOfDistributionLists());
        UpdateTest.assertEquals((String)"number of distribution list members wrong", (int)4, (int)updatedContact.getDistributionList().length);
        UpdateTest.assertTrue((String)"distribution list wrong", (boolean)Arrays.equals(savedContact.getDistributionList(), updatedContact.getDistributionList()));
    }

    public void testAddImage() throws Exception {
        String folderId = "500007";
        Contact contact = new Contact();
        contact.setCreatedBy(this.getUserID());
        contact.setDisplayName("Bernd Bein");
        contact.setGivenName("Bernd");
        contact.setSurName("Bein");
        contact.setEmail1("bernd.bein@example.com");
        contact.setUid(UUID.randomUUID().toString());
        this.getStorage().create(this.getSession(), "500007", contact);
        super.rememberForCleanUp(contact);
        Contact savedContact = super.findContact(contact.getUid(), "500007");
        UpdateTest.assertNotNull((String)"contact not found", (Object)savedContact);
        UpdateTest.assertEquals((String)"display name wrong", (String)contact.getDisplayName(), (String)savedContact.getDisplayName());
        UpdateTest.assertEquals((String)"surname wrong", (String)contact.getSurName(), (String)savedContact.getSurName());
        UpdateTest.assertEquals((String)"givenname wrong", (String)contact.getGivenName(), (String)savedContact.getGivenName());
        UpdateTest.assertEquals((String)"email1 wrong", (String)contact.getEmail1(), (String)savedContact.getEmail1());
        Date clientLastModified = savedContact.getLastModified();
        savedContact.setImage1(Data.image);
        savedContact.setImageContentType("image/png");
        String objectID = Integer.toString(savedContact.getObjectID());
        this.getStorage().update(this.getSession(), "500007", objectID, savedContact, clientLastModified);
        super.rememberForCleanUp(contact);
        Contact updatedContact = super.findContact(contact.getUid(), "500007", clientLastModified);
        UpdateTest.assertNotNull((String)"contact not found", (Object)updatedContact);
        UpdateTest.assertNotNull((String)"no image found", (Object)updatedContact.getImage1());
        UpdateTest.assertEquals((String)"number of images wrong", (int)1, (int)updatedContact.getNumberOfImages());
        UpdateTest.assertTrue((String)"image wrong", (boolean)Arrays.equals(savedContact.getImage1(), updatedContact.getImage1()));
        UpdateTest.assertEquals((String)"image content type wrong", (String)savedContact.getImageContentType(), (String)updatedContact.getImageContentType());
    }

    public void testRemoveImage() throws Exception {
        String folderId = "500004";
        Contact contact = new Contact();
        contact.setCreatedBy(this.getUserID());
        contact.setDisplayName("Dirk Dampf");
        contact.setGivenName("Dirk");
        contact.setSurName("Dampf");
        contact.setEmail1("dirk.dampf@example.com");
        contact.setUid(UUID.randomUUID().toString());
        contact.setImage1(Data.image);
        contact.setImageContentType("image/png");
        this.getStorage().create(this.getSession(), "500004", contact);
        super.rememberForCleanUp(contact);
        Contact savedContact = super.findContact(contact.getUid(), "500004");
        UpdateTest.assertNotNull((String)"contact not found", (Object)savedContact);
        UpdateTest.assertNotNull((String)"no image found", (Object)savedContact.getImage1());
        UpdateTest.assertEquals((String)"number of images wrong", (int)1, (int)savedContact.getNumberOfImages());
        UpdateTest.assertTrue((String)"image wrong", (boolean)Arrays.equals(contact.getImage1(), savedContact.getImage1()));
        UpdateTest.assertEquals((String)"image content type wrong", (String)contact.getImageContentType(), (String)savedContact.getImageContentType());
        Date clientLastModified = savedContact.getLastModified();
        savedContact.setImage1(null);
        savedContact.setImageContentType(null);
        savedContact.setNumberOfImages(0);
        String objectID = Integer.toString(savedContact.getObjectID());
        this.getStorage().update(this.getSession(), "500004", objectID, savedContact, clientLastModified);
        super.rememberForCleanUp(contact);
        Contact updatedContact = super.findContact(contact.getUid(), "500004", clientLastModified);
        UpdateTest.assertNotNull((String)"contact not found", (Object)updatedContact);
        UpdateTest.assertNull((String)"image still found", (Object)updatedContact.getImage1());
        UpdateTest.assertEquals((String)"number of images wrong", (int)0, (int)updatedContact.getNumberOfImages());
        UpdateTest.assertNull((String)"image content type wrong", (Object)updatedContact.getImageContentType());
    }
}

