/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class Bug35992Test
extends AbstractAJAXSession {
    private AJAXClient client1;
    private TimeZone timeZone;
    private Task task;

    public Bug35992Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.timeZone = this.client1.getValues().getTimeZone();
        this.task = new Task();
        this.task.setParentFolderID(this.client1.getValues().getPrivateTaskFolder());
        this.task.setTitle("Test for bug 35992");
        ExternalUserParticipant participant = new ExternalUserParticipant("");
        participant.setDisplayName("");
        this.task.addParticipant((Participant)participant);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        if (this.task.containsObjectID()) {
            this.client1.execute(new DeleteRequest(this.task));
        }
        super.tearDown();
    }

    @Test
    public void testForExternalParticipantWithEmpyEMail() throws OXException, IOException, JSONException {
        InsertResponse response = this.client1.execute(new InsertRequest(this.task, this.timeZone, false));
        if (!response.hasError()) {
            response.fillTask(this.task);
        }
        Bug35992Test.assertTrue((String)"Creating task with external participants having an empty email address should not be possible.", (boolean)response.hasError());
        Bug35992Test.assertTrue((String)"Did not get expected exception about external participant with empty email address.", (boolean)TaskExceptionCode.EXTERNAL_WITHOUT_MAIL.create().similarTo(response.getException()));
    }
}

