/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.snippet.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.snippet.actions.AbstractSnippetRequest;
import com.openexchange.ajax.snippet.actions.AttachSnippetParser;
import com.openexchange.ajax.snippet.actions.AttachSnippetResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import org.json.JSONException;

public class AttachSnippetRequest
extends AbstractSnippetRequest<AttachSnippetResponse> {
    private byte[] body;
    private int sid;

    protected AttachSnippetRequest(boolean failOnError) {
        super(failOnError);
    }

    public AttachSnippetRequest(byte[] body, int sid, boolean failOnError) {
        super(failOnError);
        this.body = body;
        this.sid = sid;
    }

    public AttachSnippetRequest(byte[] body, int sid) {
        this(body, sid, true);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.POST;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        LinkedList<AJAXRequest.Parameter> params = new LinkedList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.URLParameter("action", "attach"));
        params.add(new AJAXRequest.URLParameter("id", Integer.toString(this.sid)));
        params.add(new AJAXRequest.URLParameter("type", "image"));
        params.add(new AJAXRequest.FileParameter("file", "blah", new ByteArrayInputStream(this.body), "image/png"));
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends AttachSnippetResponse> getParser() {
        return new AttachSnippetParser(this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return null;
    }

    @Override
    public Header[] getHeaders() {
        return new Header[]{new Header.SimpleHeader("Content-Type", "multipart/form-data")};
    }
}

