/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.ajax.mail.filter.AbstractMailFilterTest;
import com.openexchange.ajax.mail.filter.Rule;
import com.openexchange.ajax.mail.filter.action.AbstractAction;
import com.openexchange.ajax.mail.filter.action.Move;
import com.openexchange.ajax.mail.filter.comparison.ContainsComparison;
import com.openexchange.ajax.mail.filter.test.HeaderTest;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Arrays;
import java.util.List;

public class Bug18490Test
extends AbstractMailFilterTest {
    FolderObject folder;
    AJAXClient client;

    public Bug18490Test(String name) {
        super(name);
    }

    public void testBug18490() throws Exception {
        AJAXSession ajaxSession = this.getSession();
        this.client = this.getClient();
        this.folder = Create.createPrivateFolder("Bug18490 test F\u00f6lder", 7, this.client.getValues().getUserId(), new OCLPermission[0]);
        this.folder.setFullName(this.client.getValues().getInboxFolder() + "/Bug18490 test F\u00f6lder");
        InsertResponse folderInsertResponse = this.client.execute(new InsertRequest(EnumAPI.OX_NEW, this.folder));
        folderInsertResponse.fillObject((DataObject)this.folder);
        String forUser = null;
        Bug18490Test.deleteAllExistingRules(forUser, ajaxSession);
        Rule rule = new Rule();
        rule.setName("Bug18490 test rule");
        rule.setActive(true);
        rule.setActioncmds(new AbstractAction[]{new Move(this.folder.getFullName())});
        ContainsComparison conComp = new ContainsComparison();
        rule.setTest(new HeaderTest(conComp, new String[]{"Subject"}, new String[]{"Bug18490"}));
        String id = Bug18490Test.insertRule(rule, forUser, ajaxSession);
        String[] idArray = Bug18490Test.getIdArray(forUser, ajaxSession);
        Bug18490Test.assertEquals((String)"one rules expected", (int)1, (int)idArray.length);
        Rule loadRule = Bug18490Test.loadRules(forUser, id, ajaxSession);
        Bug18490Test.compareRule(rule, loadRule);
        TestMail testMail = new TestMail();
        testMail.setSubject("Bug18490 testmail");
        testMail.setTo(Arrays.asList(this.client.getValues().getSendAddress()));
        testMail.setFrom(this.client.getValues().getSendAddress());
        testMail.setContentType(MailContentType.PLAIN.toString());
        testMail.setBody("Move me...");
        testMail.sanitize();
        MailTestManager mtm = new MailTestManager(this.client, true);
        mtm.send(testMail);
        List<TestMail> mails = mtm.findAndLoadSimilarMails(testMail, this.client, this.folder.getFullName());
        Bug18490Test.assertFalse((String)"No mail was found", (null == mails ? 1 : 0) != 0);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.folder != null) {
            this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.folder));
        }
        super.tearDown();
    }
}

