/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.AttachmentResponse;
import com.openexchange.java.Strings;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;

public final class AttachmentRequest
extends AbstractMailRequest<AttachmentResponse> {
    private final String[] folderAndIDAndSequenceID;
    private final boolean failOnError;
    private boolean saveToDisk;
    private boolean filter;
    private boolean fromStructure;

    public AttachmentRequest(String folder, String ID, String sequenceId) {
        this(new String[]{folder, ID, sequenceId}, true);
    }

    public AttachmentRequest(String[] folderAndIDAndSequenceID) {
        this(folderAndIDAndSequenceID, true);
    }

    public AttachmentRequest(String[] folderAndIDAndSequenceID, boolean failOnError) {
        this.folderAndIDAndSequenceID = folderAndIDAndSequenceID;
        this.failOnError = failOnError;
    }

    public AttachmentRequest setFromStructure(boolean fromStructure) {
        this.fromStructure = fromStructure;
        return this;
    }

    @Override
    public Object getBody() throws JSONException {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> l = new LinkedList<AJAXRequest.Parameter>();
        l.add(new AJAXRequest.Parameter("action", "attachment"));
        l.add(new AJAXRequest.Parameter("folder", this.folderAndIDAndSequenceID[0]));
        l.add(new AJAXRequest.Parameter("id", this.folderAndIDAndSequenceID[1]));
        l.add(new AJAXRequest.Parameter("attachment", this.folderAndIDAndSequenceID[2]));
        l.add(new AJAXRequest.Parameter("save", String.valueOf(this.saveToDisk ? 1 : 0)));
        l.add(new AJAXRequest.Parameter("filter", this.filter ? "true" : "false"));
        l.add(new AJAXRequest.Parameter("from_structure", this.fromStructure ? "true" : "false"));
        return l.toArray(new AJAXRequest.Parameter[0]);
    }

    public AttachmentParser getParser() {
        return new AttachmentParser(this.failOnError);
    }

    public boolean isSaveToDisk() {
        return this.saveToDisk;
    }

    public void setSaveToDisk(boolean saveToDisk) {
        this.saveToDisk = saveToDisk;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    class AttachmentParser
    extends AbstractAJAXParser<AttachmentResponse> {
        private String strBody;
        private byte[] bytesBody;

        AttachmentParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        public String checkResponse(HttpResponse resp) throws ParseException, IOException {
            AttachmentParser.assertEquals((String)("Response code is not okay. (" + resp.getStatusLine().getReasonPhrase() + ")"), (long)200L, (long)resp.getStatusLine().getStatusCode());
            Header contentType = resp.getFirstHeader("Content-Type");
            if (Strings.asciiLowerCase((String)contentType.getValue()).startsWith("text/")) {
                this.strBody = EntityUtils.toString((HttpEntity)resp.getEntity());
            } else {
                this.bytesBody = EntityUtils.toByteArray((HttpEntity)resp.getEntity());
            }
            return "{}";
        }

        @Override
        public AttachmentResponse parse(String body) throws JSONException {
            if (body.length() == 0) {
                return new AttachmentResponse(new Response());
            }
            return null == this.strBody ? new AttachmentResponse(this.bytesBody) : new AttachmentResponse(this.strBody);
        }

        @Override
        protected AttachmentResponse createResponse(Response response) throws JSONException {
            return new AttachmentResponse(response);
        }
    }
}

