/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.actions.NewMailResponse;
import com.openexchange.exception.OXException;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class MoveMailTest
extends AbstractMailTest {
    private UserValues values;

    public MoveMailTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        this.clearFolder(this.values.getSentFolder());
        this.clearFolder(this.values.getInboxFolder());
        this.clearFolder(this.values.getDraftsFolder());
        super.tearDown();
    }

    public void testShouldMoveFromSentToDrafts() throws OXException, IOException, SAXException, JSONException {
        MailTestManager manager = new MailTestManager(this.client, false);
        String eml = "Date: Mon, 19 Nov 2012 21:36:51 +0100 (CET)\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Message-ID: <1508703313.17483.1353357411049>\n" + "Subject: Move a mail\n" + "MIME-Version: 1.0\n" + "Content-Type: multipart/alternative; \n" + "    boundary=\"----=_Part_17482_1388684087.1353357411002\"\n" + "\n" + "------=_Part_17482_1388684087.1353357411002\n" + "MIME-Version: 1.0\n" + "Content-Type: text/plain; charset=UTF-8\n" + "Content-Transfer-Encoding: 7bit\n" + "\n" + "Move from sent to drafts\n" + "------=_Part_17482_1388684087.1353357411002\n" + "MIME-Version: 1.0\n" + "Content-Type: text/html; charset=UTF-8\n" + "Content-Transfer-Encoding: 7bit\n" + "\n" + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\">" + " <head>\n" + "    <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\"/>\n" + " </head><body style=\"font-family: verdana,geneva; font-size: 10pt; \">\n" + " \n" + "  <div>\n" + "   Move from sent to drafts\n" + "  </div>\n" + " \n" + "</body></html>\n" + "------=_Part_17482_1388684087.1353357411002--\n";
        this.getClient().execute(new NewMailRequest(this.getInboxFolder(), eml, -1, true));
        String origin = this.values.getInboxFolder();
        String destination = this.values.getDraftsFolder();
        TestMail myMail = new TestMail(this.getFirstMailInFolder(origin));
        String oldID = myMail.getId();
        TestMail movedMail = manager.move(myMail, destination);
        String newID = movedMail.getId();
        manager.get(destination, newID);
        MoveMailTest.assertTrue((String)"Should produce no errors when getting moved e-mail", (!manager.getLastResponse().hasError() ? 1 : 0) != 0);
        MoveMailTest.assertTrue((String)"Should produce no conflicts when getting moved e-mail", (!manager.getLastResponse().hasConflicts() ? 1 : 0) != 0);
        manager.get(origin, oldID);
        MoveMailTest.assertTrue((String)"Should produce errors when trying to get moved e-mail from original place", (boolean)manager.getLastResponse().hasError());
    }

    public void testShouldNotMoveToNonExistentFolder() throws OXException, IOException, SAXException, JSONException {
        MailTestManager manager = new MailTestManager(this.client, false);
        String eml = "Date: Mon, 19 Nov 2012 21:36:51 +0100 (CET)\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Message-ID: <1508703313.17483.1353357411049>\n" + "Subject: Move a mail\n" + "MIME-Version: 1.0\n" + "Content-Type: multipart/alternative; \n" + "    boundary=\"----=_Part_17482_1388684087.1353357411002\"\n" + "\n" + "------=_Part_17482_1388684087.1353357411002\n" + "MIME-Version: 1.0\n" + "Content-Type: text/plain; charset=UTF-8\n" + "Content-Transfer-Encoding: 7bit\n" + "\n" + "Move from sent to drafts\n" + "------=_Part_17482_1388684087.1353357411002\n" + "MIME-Version: 1.0\n" + "Content-Type: text/html; charset=UTF-8\n" + "Content-Transfer-Encoding: 7bit\n" + "\n" + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\">" + " <head>\n" + "    <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\"/>\n" + " </head><body style=\"font-family: verdana,geneva; font-size: 10pt; \">\n" + " \n" + "  <div>\n" + "   Move from sent to drafts\n" + "  </div>\n" + " \n" + "</body></html>\n" + "------=_Part_17482_1388684087.1353357411002--\n";
        this.getClient().execute(new NewMailRequest(this.getInboxFolder(), eml, -1, true));
        String origin = this.values.getInboxFolder();
        String destination = this.values.getDraftsFolder() + "doesn't exist";
        TestMail myMail = new TestMail(this.getFirstMailInFolder(origin));
        String oldID = myMail.getId();
        manager.move(myMail, destination);
        MoveMailTest.assertTrue((String)"Should produce error message when trying to move to nonexistent folder", (boolean)manager.getLastResponse().hasError());
        MoveMailTest.assertEquals((String)"Should produce proper error message ", (String)"IMAP-1002", (String)manager.getLastResponse().getException().getErrorCode());
        manager.get(origin, oldID);
        MoveMailTest.assertTrue((String)"Should still have e-mail at original location", (!manager.getLastResponse().hasError() ? 1 : 0) != 0);
        MoveMailTest.assertTrue((String)"Should produce no conflicts when getting e-mail from original location", (!manager.getLastResponse().hasConflicts() ? 1 : 0) != 0);
    }

    public void testShouldNotTryToMoveToSameFolder() throws Exception {
        MailTestManager manager = new MailTestManager(this.client, true);
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: #ADDR#\nTo: #ADDR#\nSubject: Invitation for launch\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nThis is a MIME message. If you are reading this text, you may want to \nconsider changing to a mail reader or gateway that understands how to \nproperly handle MIME multipart messages.".replaceAll("#ADDR#", this.getSendAddress());
        NewMailResponse newMailResponse = this.getClient().execute(new NewMailRequest(this.getInboxFolder(), eml, -1, true));
        String folder = newMailResponse.getFolder();
        String id = newMailResponse.getId();
        TestMail newMail = manager.get(new String[]{folder, id});
        MoveMailTest.assertNotNull((String)"New mail may not be null and has to be found in sent-items folder", (Object)newMail);
        TestMail movedMail = manager.move(newMail, folder);
        MoveMailTest.assertNotNull((String)"Moved mail may not be null", (Object)movedMail);
        MoveMailTest.assertEquals((String)"Mail should not be moved and remain in the original folder.", (String)folder, (String)movedMail.getFolder());
        MoveMailTest.assertEquals((String)"Mail shouldn't have been duplicated", (int)1, (int)manager.findSimilarMailsInSameFolder(newMail, this.client).size());
    }
}

