/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.jump.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.jump.actions.AbstractJumpRequest;
import com.openexchange.ajax.jump.actions.IdentityTokenResponse;
import java.io.IOException;
import java.util.LinkedList;
import org.json.JSONException;
import org.json.JSONObject;

public class IdentityTokenRequest
extends AbstractJumpRequest<IdentityTokenResponse> {
    private final String systemName;
    private final boolean failOnError;

    public IdentityTokenRequest(String systemName) {
        this(true, systemName);
    }

    public IdentityTokenRequest(boolean failOnError, String systemName) {
        this.failOnError = failOnError;
        this.systemName = systemName;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", "identityToken"));
        list.add(new AJAXRequest.Parameter("system", this.systemName));
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends IdentityTokenResponse> getParser() {
        return new IdentityTokenParser(this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return null;
    }

    private static class IdentityTokenParser
    extends AbstractAJAXParser<IdentityTokenResponse> {
        protected IdentityTokenParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected IdentityTokenResponse createResponse(Response response) throws JSONException {
            JSONObject jObject = (JSONObject)response.getData();
            return new IdentityTokenResponse(response, jObject.getString("token"));
        }
    }
}

