/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.importexport.formats.Format;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractImportRequest<T extends AbstractAJAXResponse>
implements AJAXRequest<T> {
    public static final String IMPORT_URL = "/ajax/import";
    private final Action action;
    private final int folderId;
    private final InputStream upload;
    private final AJAXRequest.Parameter[] additionalParameters;

    public AbstractImportRequest(Action action, int folderId, InputStream upload) {
        this(action, folderId, upload, null);
    }

    public AbstractImportRequest(Action action, int folderId, InputStream upload, AJAXRequest.Parameter ... additionalParameters) {
        this.action = action;
        this.folderId = folderId;
        this.upload = upload;
        this.additionalParameters = additionalParameters;
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.UPLOAD;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> parameters = new ArrayList<AJAXRequest.Parameter>();
        parameters.add(new AJAXRequest.Parameter("action", this.action.getName()));
        parameters.add(new AJAXRequest.Parameter("folder", this.folderId));
        parameters.add(new AJAXRequest.FileParameter("file", this.action.fileName, this.upload, this.action.format.getMimeType()));
        if (null != this.additionalParameters && 0 < this.additionalParameters.length) {
            parameters.addAll(Arrays.asList(this.additionalParameters));
        }
        return parameters.toArray(new AJAXRequest.Parameter[parameters.size()]);
    }

    @Override
    public String getServletPath() {
        return IMPORT_URL;
    }

    protected static enum Action {
        CSV("CSV", "contacts.csv", Format.CSV),
        ICal("ICAL", "ical.ics", Format.ICAL),
        VCard("VCARD", "vcard.vcf", Format.VCARD),
        OUTLOOK_CSV("OUTLOOK_CSV", "contacts.csv", Format.OUTLOOK_CSV),
        FacebookFriends("FacebookFriends", "friends.html", Format.FacebookFriends),
        FacebookArchive("FacebookArchive", "facebook.zip", Format.FacebookArchive);

        private final String name;
        private final String fileName;
        private final Format format;

        private Action(String name, String fileName, Format format) {
            this.name = name;
            this.fileName = fileName;
            this.format = format;
        }

        public String getName() {
            return this.name;
        }
    }
}

