/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.importexport.actions.VCardExportRequest;
import com.openexchange.ajax.importexport.actions.VCardExportResponse;
import com.openexchange.ajax.importexport.actions.VCardImportRequest;
import com.openexchange.ajax.importexport.actions.VCardImportResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug25701Test
extends AbstractManagedContactTest {
    public Bug25701Test(String name) {
        super(name);
    }

    public void testCombinedTypes() throws Exception {
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\n\nN:test;heinz;;;\r\nTEL;TYPE=voice,home:43643634634\r\nEND:VCARD\r\n";
        Contact importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"43643634634", (String)importedContact.getTelephoneHome1());
        vCard = this.export();
        this.manager.deleteAction(importedContact);
        importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"43643634634", (String)importedContact.getTelephoneHome1());
        this.manager.deleteAction(importedContact);
    }

    public void testPreferredTelephoneHomeType() throws Exception {
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\n\nN:test;heinz;;;\r\nTEL;TYPE=voice,home:17858358734\r\nTEL;TYPE=voice,home:23455464534\r\nTEL;TYPE=pref,voice,home:33465472555\r\nTEL;TYPE=pref,voice,home:47574573624\r\nEND:VCARD\r\n";
        Contact importedContact = this.importAndFetch(vCard);
        List<String> homeTelephoneNumbers = Arrays.asList(importedContact.getTelephoneHome1(), importedContact.getTelephoneHome2());
        Bug25701Test.assertTrue((String)"33465472555 not found", (boolean)homeTelephoneNumbers.contains("33465472555"));
        Bug25701Test.assertTrue((String)"47574573624 not found", (boolean)homeTelephoneNumbers.contains("47574573624"));
        vCard = this.export();
        this.manager.deleteAction(importedContact);
        importedContact = this.importAndFetch(vCard);
        homeTelephoneNumbers = Arrays.asList(importedContact.getTelephoneHome1(), importedContact.getTelephoneHome2());
        Bug25701Test.assertTrue((String)"33465472555 not found", (boolean)homeTelephoneNumbers.contains("33465472555"));
        Bug25701Test.assertTrue((String)"47574573624 not found", (boolean)homeTelephoneNumbers.contains("47574573624"));
        this.manager.deleteAction(importedContact);
    }

    public void testPreferredTelephoneBusinessType() throws Exception {
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\n\nN:test;heinz;;;\r\nTEL;TYPE=voice,work:17858358734\r\nTEL;TYPE=voice,work:23455464534\r\nTEL;TYPE=pref,voice,work:33465472555\r\nTEL;TYPE=pref,voice,work:47574573624\r\nEND:VCARD\r\n";
        Contact importedContact = this.importAndFetch(vCard);
        List<String> businessTelephoneNumbers = Arrays.asList(importedContact.getTelephoneBusiness1(), importedContact.getTelephoneBusiness2());
        Bug25701Test.assertTrue((String)"33465472555 not found", (boolean)businessTelephoneNumbers.contains("33465472555"));
        Bug25701Test.assertTrue((String)"47574573624 not found", (boolean)businessTelephoneNumbers.contains("47574573624"));
        vCard = this.export();
        this.manager.deleteAction(importedContact);
        importedContact = this.importAndFetch(vCard);
        businessTelephoneNumbers = Arrays.asList(importedContact.getTelephoneBusiness1(), importedContact.getTelephoneBusiness2());
        Bug25701Test.assertTrue((String)"33465472555 not found", (boolean)businessTelephoneNumbers.contains("33465472555"));
        Bug25701Test.assertTrue((String)"47574573624 not found", (boolean)businessTelephoneNumbers.contains("47574573624"));
        this.manager.deleteAction(importedContact);
    }

    public void testPreferredFaxHomeType() throws Exception {
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\n\nN:test;heinz;;;\r\nTEL;TYPE=fax,home:17858358734\r\nTEL;TYPE=fax,home:23455464534\r\nTEL;TYPE=pref,fax,home:33465472555\r\nEND:VCARD\r\n";
        Contact importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"33465472555 not found", (String)"33465472555", (String)importedContact.getFaxHome());
        vCard = this.export();
        this.manager.deleteAction(importedContact);
        importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"33465472555 not found", (String)"33465472555", (String)importedContact.getFaxHome());
        this.manager.deleteAction(importedContact);
    }

    public void testPreferredFaxBusinessType() throws Exception {
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\n\nN:test;heinz;;;\r\nTEL;TYPE=fax,work:17858358734\r\nTEL;TYPE=fax,work:23455464534\r\nTEL;TYPE=pref,fax,work:33465472555\r\nEND:VCARD\r\n";
        Contact importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"33465472555 not found", (String)"33465472555", (String)importedContact.getFaxBusiness());
        vCard = this.export();
        this.manager.deleteAction(importedContact);
        importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"33465472555 not found", (String)"33465472555", (String)importedContact.getFaxBusiness());
        this.manager.deleteAction(importedContact);
    }

    public void testTextphoneType() throws Exception {
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\n\nN:test;heinz;;;\r\nTEL;TYPE=textphone:43643634634\r\nEND:VCARD\r\n";
        Contact importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"43643634634", (String)importedContact.getTelephoneTTYTTD());
        vCard = this.export();
        this.manager.deleteAction(importedContact);
        importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"43643634634", (String)importedContact.getTelephoneTTYTTD());
        this.manager.deleteAction(importedContact);
    }

    public void testPagerType() throws Exception {
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\n\nN:test;heinz;;;\r\nTEL;TYPE=pager:43643634634\r\nEND:VCARD\r\n";
        Contact importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"43643634634", (String)importedContact.getTelephonePager());
        vCard = this.export();
        this.manager.deleteAction(importedContact);
        importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"43643634634", (String)importedContact.getTelephonePager());
        this.manager.deleteAction(importedContact);
    }

    public void testCarType() throws Exception {
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\n\nN:test;heinz;;;\r\nTEL;TYPE=car:43643634634\r\nEND:VCARD\r\n";
        Contact importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"43643634634", (String)importedContact.getTelephoneCar());
        vCard = this.export();
        this.manager.deleteAction(importedContact);
        importedContact = this.importAndFetch(vCard);
        Bug25701Test.assertEquals((String)"43643634634", (String)importedContact.getTelephoneCar());
        this.manager.deleteAction(importedContact);
    }

    private Contact importAndFetch(String vCard) throws Exception {
        VCardImportRequest importRequest = new VCardImportRequest(this.folderID, new ByteArrayInputStream(vCard.getBytes(Charsets.UTF_8)));
        VCardImportResponse importResponse = this.getClient().execute(importRequest);
        JSONArray data = (JSONArray)importResponse.getData();
        Bug25701Test.assertTrue((String)"got no data from import request", (null != data && 0 < data.length() ? 1 : 0) != 0);
        JSONObject jsonObject = data.getJSONObject(0);
        Bug25701Test.assertNotNull((String)"got no data from import request", (Object)jsonObject);
        int objectID = jsonObject.optInt("id");
        Bug25701Test.assertTrue((String)"got no object id from import request", (0 < objectID ? 1 : 0) != 0);
        return this.manager.getAction(this.folderID, objectID);
    }

    private String export() throws Exception {
        VCardExportRequest exportRequest = new VCardExportRequest(this.folderID, false);
        VCardExportResponse exportResponse = this.manager.getClient().execute(exportRequest);
        return exportResponse.getVCard();
    }
}

