/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.calendar;

import com.openexchange.ajax.find.actions.AutocompleteRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.find.calendar.CalendarFindTest;
import com.openexchange.find.Module;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.groupware.container.Contact;
import com.openexchange.test.ContactTestManager;

public class AutocompleteTest
extends CalendarFindTest {
    private ContactTestManager contactManager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.contactManager = new ContactTestManager(this.client);
    }

    @Override
    public void tearDown() throws Exception {
        this.contactManager.cleanUp();
        super.tearDown();
    }

    public AutocompleteTest(String name) {
        super(name);
    }

    public void noTestAutocompleteCurrentUser() throws Exception {
        String defaultAddress = this.client.getValues().getDefaultAddress();
        this.assertFoundFacetInAutocomplete(defaultAddress.substring(0, 3), defaultAddress);
    }

    public void noTestAutocompleteOtherContact() throws Exception {
        Contact contact = new Contact();
        contact.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        contact.setSurName(AutocompleteTest.randomUID());
        contact.setGivenName(AutocompleteTest.randomUID());
        contact.setDisplayName(contact.getGivenName() + " " + contact.getSurName());
        contact.setEmail1(AutocompleteTest.randomUID() + "@example.com");
        contact.setEmail2(AutocompleteTest.randomUID() + "@example.com");
        contact.setEmail3(AutocompleteTest.randomUID() + "@example.com");
        contact.setUid(AutocompleteTest.randomUID());
        contact = this.contactManager.newAction(contact);
        this.assertFoundFacetInAutocomplete(contact.getDisplayName().substring(0, 3), contact.getEmail1());
        this.assertFoundFacetInAutocomplete(contact.getSurName().substring(0, 4), contact.getEmail1());
        this.assertFoundFacetInAutocomplete(contact.getGivenName().substring(0, 5), contact.getEmail1());
        this.assertFoundFacetInAutocomplete(contact.getEmail1().substring(0, 3), contact.getEmail1());
        this.assertFoundFacetInAutocomplete(contact.getEmail2().substring(0, 6), contact.getEmail1());
        this.assertFoundFacetInAutocomplete(contact.getEmail3().substring(0, 5), contact.getEmail1());
    }

    private FacetValue assertFoundFacetInAutocomplete(String prefix, String expectedEmail1) throws Exception {
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, Module.CALENDAR.getIdentifier());
        AutocompleteResponse autocompleteResponse = this.client.execute(autocompleteRequest);
        FacetValue foundFacetValue = AutocompleteTest.findByDisplayName(autocompleteResponse.getFacets(), expectedEmail1);
        AutocompleteTest.assertNotNull((String)("no facet value found for: " + expectedEmail1), (Object)foundFacetValue);
        return foundFacetValue;
    }
}

